/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.dispatcher;

import io.zeebe.dispatcher.AtomicPosition;
import io.zeebe.dispatcher.ClaimedFragment;
import io.zeebe.dispatcher.ClaimedFragmentBatch;
import io.zeebe.dispatcher.Subscription;
import io.zeebe.dispatcher.impl.PositionUtil;
import io.zeebe.dispatcher.impl.log.LogBuffer;
import io.zeebe.dispatcher.impl.log.LogBufferAppender;
import io.zeebe.dispatcher.impl.log.LogBufferPartition;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorCondition;
import io.zeebe.util.sched.FutureUtil;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.Arrays;
import java.util.function.BiFunction;
import org.agrona.DirectBuffer;

public class Dispatcher
extends Actor
implements AutoCloseable {
    public static final int MODE_PUB_SUB = 1;
    public static final int MODE_PIPELINE = 2;
    private static final String ERROR_MESSAGE_CLAIM_FAILED = "Expected to claim segment of size %d, but can't claim more then %d bytes.";
    private static final String ERROR_MESSAGE_SUBSCRIPTION_NOT_FOUND = "Expected to find subscription with name '%s', but was not registered.";
    protected final LogBuffer logBuffer;
    protected final LogBufferAppender logAppender;
    protected final AtomicPosition publisherLimit;
    protected final AtomicPosition publisherPosition;
    protected final String[] defaultSubscriptionNames;
    protected final int maxFrameLength;
    protected final int partitionSize;
    protected final String name;
    protected final int mode;
    protected Subscription[] subscriptions;
    private final Runnable onClaimComplete = this::signalSubsciptions;
    protected int logWindowLength;
    protected volatile boolean isClosed = false;
    private final Runnable backgroundTask = this::runBackgroundTask;
    private ActorCondition dataConsumed;

    public Dispatcher(LogBuffer logBuffer, LogBufferAppender logAppender, AtomicPosition publisherLimit, AtomicPosition publisherPosition, int logWindowLength, String[] subscriptionNames, int mode, String name) {
        this.logBuffer = logBuffer;
        this.logAppender = logAppender;
        this.publisherLimit = publisherLimit;
        this.publisherPosition = publisherPosition;
        this.logWindowLength = logWindowLength;
        this.mode = mode;
        this.name = name;
        this.partitionSize = logBuffer.getPartitionSize();
        this.maxFrameLength = this.partitionSize / 16;
        this.subscriptions = new Subscription[0];
        this.defaultSubscriptionNames = subscriptionNames;
    }

    public String getName() {
        return this.name;
    }

    protected void onActorStarted() {
        this.dataConsumed = this.actor.onCondition("data-consumed", this.backgroundTask);
        this.openDefaultSubscriptions();
    }

    protected void onActorClosing() {
        Subscription[] subscriptionsCopy;
        this.publisherLimit.reset();
        this.publisherPosition.reset();
        for (Subscription subscription : subscriptionsCopy = Arrays.copyOf(this.subscriptions, this.subscriptions.length)) {
            this.doCloseSubscription(subscription);
        }
        this.logBuffer.close();
        this.isClosed = true;
    }

    private void runBackgroundTask() {
        this.updatePublisherLimit();
        this.logBuffer.cleanPartitions();
    }

    protected void openDefaultSubscriptions() {
        int subscriptionSize = this.defaultSubscriptionNames == null ? 0 : this.defaultSubscriptionNames.length;
        for (int i = 0; i < subscriptionSize; ++i) {
            this.doOpenSubscription(this.defaultSubscriptionNames[i], this.dataConsumed);
        }
    }

    public long offer(DirectBuffer msg) {
        return this.offer(msg, 0, msg.capacity(), 0);
    }

    public long offer(DirectBuffer msg, int streamId) {
        return this.offer(msg, 0, msg.capacity(), streamId);
    }

    public long offer(DirectBuffer msg, int start, int length) {
        return this.offer(msg, start, length, 0);
    }

    public long offer(DirectBuffer msg, int start, int length, int streamId) {
        return this.offer((LogBufferPartition partition, Integer activePartitionId) -> this.logAppender.appendFrame((LogBufferPartition)partition, (int)activePartitionId, msg, start, length, streamId), length);
    }

    private void signalSubsciptions() {
        Subscription[] subscriptions = this.subscriptions;
        for (int i = 0; i < subscriptions.length; ++i) {
            subscriptions[i].getActorConditions().signalConsumers();
        }
    }

    public long claim(ClaimedFragment claim, int length) {
        return this.claim(claim, length, 0);
    }

    public long claim(ClaimedFragment claim, int length, int streamId) {
        return this.offer((LogBufferPartition partition, Integer activePartitionId) -> this.logAppender.claim((LogBufferPartition)partition, (int)activePartitionId, claim, length, streamId, this.onClaimComplete), length);
    }

    public long claim(ClaimedFragmentBatch batch, int fragmentCount, int batchLength) {
        return this.offer((LogBufferPartition partition, Integer activePartitionId) -> this.logAppender.claim((LogBufferPartition)partition, (int)activePartitionId, batch, fragmentCount, batchLength, this.onClaimComplete), batchLength);
    }

    private long offer(BiFunction<LogBufferPartition, Integer, Integer> claimer, int length) {
        long newPosition = -1L;
        if (!this.isClosed) {
            LogBufferPartition partition;
            int partitionOffset;
            long limit = this.publisherLimit.get();
            int activePartitionId = this.logBuffer.getActivePartitionIdVolatile();
            long position = PositionUtil.position(activePartitionId, partitionOffset = (partition = this.logBuffer.getPartition(activePartitionId)).getTailCounterVolatile());
            if (position < limit) {
                if (length >= this.maxFrameLength) {
                    throw new IllegalArgumentException(String.format(ERROR_MESSAGE_CLAIM_FAILED, length, this.maxFrameLength));
                }
                int newOffset = claimer.apply(partition, activePartitionId);
                newPosition = this.updatePublisherPosition(activePartitionId, newOffset);
                this.publisherPosition.proposeMaxOrdered(newPosition);
                this.signalSubsciptions();
            }
        }
        return newPosition;
    }

    protected long updatePublisherPosition(int activePartitionId, int newOffset) {
        long newPosition = -1L;
        if (newOffset > 0) {
            newPosition = PositionUtil.position(activePartitionId, newOffset);
        } else if (newOffset == -2) {
            this.logBuffer.onActiveParitionFilled(activePartitionId);
            newPosition = -2L;
        }
        return newPosition;
    }

    public int updatePublisherLimit() {
        int isUpdated = 0;
        if (!this.isClosed) {
            long proposedPublisherLimit;
            long lastSubscriberPosition = -1L;
            if (this.subscriptions.length > 0) {
                lastSubscriberPosition = this.subscriptions[this.subscriptions.length - 1].getPosition();
                if (1 == this.mode && this.subscriptions.length > 1) {
                    for (int i = 0; i < this.subscriptions.length - 1; ++i) {
                        lastSubscriberPosition = Math.min(lastSubscriberPosition, this.subscriptions[i].getPosition());
                    }
                }
            } else {
                lastSubscriberPosition = Math.max(0L, this.publisherLimit.get() - (long)this.logWindowLength);
            }
            int partitionId = PositionUtil.partitionId(lastSubscriberPosition);
            int partitionOffset = PositionUtil.partitionOffset(lastSubscriberPosition) + this.logWindowLength;
            if (partitionOffset >= this.logBuffer.getPartitionSize()) {
                ++partitionId;
                partitionOffset = this.logWindowLength;
            }
            if (this.publisherLimit.proposeMaxOrdered(proposedPublisherLimit = PositionUtil.position(partitionId, partitionOffset))) {
                isUpdated = 1;
            }
        }
        return isUpdated;
    }

    public Subscription openSubscription(String subscriptionName) {
        return (Subscription)FutureUtil.join(this.openSubscriptionAsync(subscriptionName));
    }

    public ActorFuture<Subscription> openSubscriptionAsync(String subscriptionName) {
        return this.actor.call(() -> {
            if (this.mode == 2) {
                throw new IllegalStateException("Cannot open subscriptions in pipelining mode");
            }
            return this.doOpenSubscription(subscriptionName, this.dataConsumed);
        });
    }

    public ActorFuture<Subscription> getSubscriptionAsync(String subscriptionName) {
        return this.actor.call(() -> this.getSubscriptionByName(subscriptionName));
    }

    public Subscription getSubscription(String subscriptionName) {
        return (Subscription)FutureUtil.join(this.getSubscriptionAsync(subscriptionName));
    }

    protected Subscription doOpenSubscription(String subscriptionName, ActorCondition onConsumption) {
        Subscription subscription;
        this.ensureUniqueSubscriptionName(subscriptionName);
        Subscription[] newSubscriptions = new Subscription[this.subscriptions.length + 1];
        System.arraycopy(this.subscriptions, 0, newSubscriptions, 0, this.subscriptions.length);
        int subscriberId = newSubscriptions.length - 1;
        newSubscriptions[subscriberId] = subscription = this.newSubscription(subscriberId, subscriptionName, onConsumption);
        this.subscriptions = newSubscriptions;
        onConsumption.signal();
        return subscription;
    }

    protected void ensureUniqueSubscriptionName(String subscriptionName) {
        if (this.findSubscriptionByName(subscriptionName) != null) {
            throw new IllegalStateException("subscription with name '" + subscriptionName + "' already exists");
        }
    }

    protected Subscription newSubscription(int subscriptionId, String subscriptionName, ActorCondition onConsumption) {
        AtomicPosition position = new AtomicPosition();
        position.set(PositionUtil.position(this.logBuffer.getActivePartitionIdVolatile(), 0));
        AtomicPosition limit = this.determineLimit(subscriptionId);
        return new Subscription(position, limit, subscriptionId, subscriptionName, onConsumption, this.logBuffer);
    }

    protected AtomicPosition determineLimit(int subscriptionId) {
        if (this.mode == 1) {
            return this.publisherPosition;
        }
        if (subscriptionId == 0) {
            return this.publisherPosition;
        }
        return this.subscriptions[subscriptionId - 1].position;
    }

    public void closeSubscription(Subscription subscriptionToClose) {
        FutureUtil.join(this.closeSubscriptionAsync(subscriptionToClose));
    }

    public ActorFuture<Void> closeSubscriptionAsync(Subscription subscriptionToClose) {
        return this.actor.call(() -> {
            if (this.mode == 2) {
                throw new IllegalStateException("Cannot close subscriptions in pipelining mode");
            }
            this.doCloseSubscription(subscriptionToClose);
        });
    }

    protected void doCloseSubscription(Subscription subscriptionToClose) {
        if (this.isClosed) {
            return;
        }
        subscriptionToClose.isClosed = true;
        subscriptionToClose.position.reset();
        int len = this.subscriptions.length;
        int index = 0;
        for (int i = 0; i < len; ++i) {
            if (subscriptionToClose != this.subscriptions[i]) continue;
            index = i;
            break;
        }
        Subscription[] newSubscriptions = null;
        int numMoved = len - index - 1;
        if (numMoved == 0) {
            newSubscriptions = Arrays.copyOf(this.subscriptions, len - 1);
        } else {
            newSubscriptions = new Subscription[len - 1];
            System.arraycopy(this.subscriptions, 0, newSubscriptions, 0, index);
            System.arraycopy(this.subscriptions, index + 1, newSubscriptions, index, numMoved);
        }
        this.subscriptions = newSubscriptions;
        this.dataConsumed.signal();
    }

    private Subscription getSubscriptionByName(String subscriptionName) {
        Subscription subscription = this.findSubscriptionByName(subscriptionName);
        if (subscription == null) {
            throw new IllegalStateException(String.format(ERROR_MESSAGE_SUBSCRIPTION_NOT_FOUND, subscriptionName));
        }
        return subscription;
    }

    protected Subscription findSubscriptionByName(String subscriptionName) {
        Subscription subscription = null;
        if (!this.isClosed) {
            for (int i = 0; i < this.subscriptions.length; ++i) {
                if (!this.subscriptions[i].getName().equals(subscriptionName)) continue;
                subscription = this.subscriptions[i];
                break;
            }
        }
        return subscription;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() {
        FutureUtil.join(this.closeAsync());
    }

    public ActorFuture<Void> closeAsync() {
        return this.actor.close();
    }

    public LogBuffer getLogBuffer() {
        return this.logBuffer;
    }

    public int getMaxFrameLength() {
        return this.maxFrameLength;
    }

    public long getPublisherPosition() {
        if (this.isClosed) {
            return -1L;
        }
        return this.publisherPosition.get();
    }

    public long getPublisherLimit() {
        if (this.isClosed) {
            return -1L;
        }
        return this.publisherLimit.get();
    }

    public String toString() {
        return "Dispatcher [" + this.name + "]";
    }
}

