/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.dispatcher;

import io.zeebe.dispatcher.impl.log.DataFrameDescriptor;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class ClaimedFragment {
    protected final UnsafeBuffer buffer = new UnsafeBuffer(0L, 0);
    private Runnable onCompleteHandler;

    public void wrap(UnsafeBuffer underlyingbuffer, int fragmentOffset, int fragmentLength, Runnable onCompleteHandler) {
        this.onCompleteHandler = onCompleteHandler;
        this.buffer.wrap((DirectBuffer)underlyingbuffer, fragmentOffset, fragmentLength);
    }

    public int getOffset() {
        return DataFrameDescriptor.HEADER_LENGTH;
    }

    public int getLength() {
        return this.buffer.capacity() - DataFrameDescriptor.HEADER_LENGTH;
    }

    public int getFragmentLength() {
        return this.buffer.capacity();
    }

    public MutableDirectBuffer getBuffer() {
        return this.buffer;
    }

    public void commit() {
        this.buffer.putIntOrdered(DataFrameDescriptor.lengthOffset(0), this.buffer.capacity());
        this.onCompleteHandler.run();
        this.reset();
    }

    public void abort() {
        this.buffer.putInt(DataFrameDescriptor.typeOffset(0), 1);
        this.buffer.putIntOrdered(DataFrameDescriptor.lengthOffset(0), this.buffer.capacity());
        this.onCompleteHandler.run();
        this.reset();
    }

    private void reset() {
        this.buffer.wrap(0L, 0);
        this.onCompleteHandler = null;
    }

    public boolean isOpen() {
        return this.getFragmentLength() > 0;
    }
}

