/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.dispatcher.impl.log;

import io.zeebe.dispatcher.impl.log.LogBufferDescriptor;
import io.zeebe.dispatcher.impl.log.LogBufferPartition;
import io.zeebe.util.allocation.AllocatedBuffer;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class PartitionBuilder {
    public LogBufferPartition[] slicePartitions(int partitionSize, AllocatedBuffer allocatedBuffer) {
        ByteBuffer buffer = allocatedBuffer.getRawBuffer();
        LogBufferPartition[] partitions = new LogBufferPartition[3];
        for (int i = 0; i < 3; ++i) {
            int dataSectionOffset = LogBufferDescriptor.partitionDataSectionOffset(partitionSize, i);
            int metaDataSectionOffset = LogBufferDescriptor.partitionMetadataSectionOffset(partitionSize, i);
            UnsafeBuffer dataSection = new UnsafeBuffer(buffer, dataSectionOffset, partitionSize);
            UnsafeBuffer metadataSection = new UnsafeBuffer(buffer, metaDataSectionOffset, LogBufferDescriptor.PARTITION_META_DATA_LENGTH);
            partitions[i] = new LogBufferPartition(dataSection, metadataSection, dataSectionOffset);
        }
        return partitions;
    }
}

