/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.options.Options;
import info.archinnov.achilles.options.OptionsBuilder;
import info.archinnov.achilles.persistence.AbstractPersistenceManager;
import info.archinnov.achilles.type.Empty;
import java.util.Map;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonAsyncManager
extends AbstractPersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(CommonAsyncManager.class);

    protected CommonAsyncManager(Map<Class<?>, EntityMeta> entityMetaMap, PersistenceContextFactory contextFactory, DaoContext daoContext, ConfigurationContext configContext) {
        super(entityMetaMap, contextFactory, daoContext, configContext);
    }

    public <T> AchillesFuture<T> insert(T entity) {
        log.debug("Inserting asynchronously entity '{}'", entity);
        return super.asyncInsert(entity, OptionsBuilder.noOptions());
    }

    public <T> AchillesFuture<T> insert(T entity, Options options) {
        log.debug("Inserting asynchronously entity '{}' with options {} ", entity, (Object)options);
        return super.asyncInsert(entity, options);
    }

    public <T> AchillesFuture<T> update(T entity) {
        log.debug("Updating asynchronously entity '{}'", this.proxifier.getRealObject(entity));
        return super.asyncUpdate(entity, OptionsBuilder.noOptions());
    }

    public <T> AchillesFuture<T> update(T entity, Options options) {
        log.debug("Updating asynchronously entity '{}' with options {} ", this.proxifier.getRealObject(entity), (Object)options);
        return super.asyncUpdate(entity, options);
    }

    public <T> AchillesFuture<T> insertOrUpdate(T entity) {
        log.debug("Inserting or updating asynchronously entity '{}'", this.proxifier.getRealObject(entity));
        return this.asyncInsertOrUpdate(entity, OptionsBuilder.noOptions());
    }

    public <T> AchillesFuture<T> insertOrUpdate(T entity, Options options) {
        log.debug("Inserting or updating asynchronously entity '{}' with options {}", this.proxifier.getRealObject(entity), (Object)options);
        return this.asyncInsertOrUpdate(entity, options);
    }

    public <T> AchillesFuture<T> delete(T entity) {
        log.debug("Removing asynchronously entity '{}'", this.proxifier.getRealObject(entity));
        return super.asyncDelete(entity, OptionsBuilder.noOptions());
    }

    public <T> AchillesFuture<T> delete(T entity, Options options) {
        log.debug("Removing asynchronously entity '{}' with options {}", this.proxifier.getRealObject(entity), (Object)options);
        return super.asyncDelete(entity, options);
    }

    public AchillesFuture<Empty> deleteById(Class<?> entityClass, Object primaryKey) {
        log.debug("Deleting asynchronously entity of type '{}' by its id '{}'", entityClass, primaryKey);
        return super.asyncDeleteById(entityClass, primaryKey, OptionsBuilder.noOptions());
    }

    public AchillesFuture<Empty> deleteById(Class<?> entityClass, Object primaryKey, Options options) {
        log.debug("Removing asynchronously entity of type '{}' by its id '{}'", entityClass, primaryKey);
        return super.asyncDeleteById(entityClass, primaryKey, options);
    }

    @PreDestroy
    public void shutDown() {
        this.configContext.getExecutorService().shutdown();
    }
}

