/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.options.Options;
import info.archinnov.achilles.options.OptionsBuilder;
import info.archinnov.achilles.persistence.AsyncBatch;
import info.archinnov.achilles.persistence.CommonAsyncManager;
import info.archinnov.achilles.query.cql.AsyncNativeQuery;
import info.archinnov.achilles.query.slice.AsyncSliceQueryBuilder;
import info.archinnov.achilles.query.typed.AsyncTypedQuery;
import info.archinnov.achilles.type.IndexCondition;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncManager
extends CommonAsyncManager {
    private static final Logger log = LoggerFactory.getLogger(AsyncManager.class);

    protected AsyncManager(Map<Class<?>, EntityMeta> entityMetaMap, PersistenceContextFactory contextFactory, DaoContext daoContext, ConfigurationContext configContext) {
        super(entityMetaMap, contextFactory, daoContext, configContext);
    }

    public <T> AchillesFuture<T> find(Class<T> entityClass, Object primaryKey) {
        log.debug("Find entity class '{}' with primary key '{}'", entityClass, primaryKey);
        return super.asyncFind(entityClass, primaryKey, OptionsBuilder.noOptions());
    }

    public <T> AchillesFuture<T> find(Class<T> entityClass, Object primaryKey, Options options) {
        log.debug("Find entity class '{}' with primary key '{}' and options '{}'", new Object[]{entityClass, primaryKey, options});
        return super.asyncFind(entityClass, primaryKey, options);
    }

    public <T> T forUpdate(Class<T> entityClass, Object primaryKey) {
        log.debug("Get reference for entity class '{}' with primary key {}", entityClass, primaryKey);
        return super.getProxyForUpdateInternal(entityClass, primaryKey);
    }

    @Override
    public <T> T initialize(T entity) {
        log.debug("Force lazy fields initialization for entity {}", this.proxifier.removeProxy(entity));
        return super.initialize(entity);
    }

    public <T> Set<T> initialize(Set<T> entities) {
        return super.initialize(entities);
    }

    public <T> List<T> initialize(List<T> entities) {
        log.debug("Force lazy fields initialization for entity set {}", entities);
        return super.initialize(entities);
    }

    public <T> T initAndRemoveProxy(T entity) {
        return super.removeProxy(super.initialize(entity));
    }

    public <T> Set<T> initAndRemoveProxy(Set<T> entities) {
        return super.removeProxy(super.initialize(entities));
    }

    public <T> List<T> initAndRemoveProxy(List<T> entities) {
        return super.removeProxy(super.initialize(entities));
    }

    @Override
    public <T> T removeProxy(T proxy) {
        return super.removeProxy(proxy);
    }

    @Override
    public <T> List<T> removeProxy(List<T> proxies) {
        log.debug("Removing proxy for a list of entities {}", proxies);
        return super.removeProxy(proxies);
    }

    @Override
    public <T> Set<T> removeProxy(Set<T> proxies) {
        log.debug("Removing proxy for a set of entities {}", proxies);
        return super.removeProxy(proxies);
    }

    public <T> AsyncSliceQueryBuilder<T> sliceQuery(Class<T> entityClass) {
        log.debug("Execute slice query for entity class {}", entityClass);
        EntityMeta meta = super.validateSliceQueryInternal(entityClass);
        return new AsyncSliceQueryBuilder<T>(this.sliceQueryExecutor, entityClass, meta);
    }

    public AsyncNativeQuery nativeQuery(Statement statement, Object ... boundValues) {
        log.debug("Execute native query {}", (Object)statement);
        Validator.validateNotNull(statement, "The statement for native query should not be null", new Object[0]);
        return new AsyncNativeQuery(this.daoContext, this.configContext, statement, OptionsBuilder.noOptions(), boundValues);
    }

    public AsyncNativeQuery nativeQuery(Statement statement, Options options, Object ... boundValues) {
        log.debug("Execute native query {}", (Object)statement);
        Validator.validateNotNull(statement, "The statement for native query should not be null", new Object[0]);
        return new AsyncNativeQuery(this.daoContext, this.configContext, statement, options, boundValues);
    }

    public <T> AsyncTypedQuery<T> typedQuery(Class<T> entityClass, Statement statement, Object ... boundValues) {
        EntityMeta meta = super.typedQueryInternal(entityClass, statement, boundValues);
        return new AsyncTypedQuery<T>(entityClass, this.daoContext, this.configContext, statement, meta, this.contextFactory, boundValues);
    }

    public <T> AsyncTypedQuery<T> indexedQuery(Class<T> entityClass, IndexCondition indexCondition) {
        log.debug("Execute indexed query for entity class {}", entityClass);
        Statement statement = super.indexedQueryInternal(entityClass, indexCondition);
        EntityMeta meta = super.typedQueryInternal(entityClass, statement, indexCondition.getColumnValue());
        return new AsyncTypedQuery<T>(entityClass, this.daoContext, this.configContext, statement, meta, this.contextFactory, new Object[]{indexCondition.getColumnValue()});
    }

    @Override
    public String serializeToJSON(Object entity) throws IOException {
        return super.serializeToJSON(entity);
    }

    @Override
    public <T> T deserializeFromJSON(Class<T> type, String serialized) throws IOException {
        return super.deserializeFromJSON(type, serialized);
    }

    @Override
    public Session getNativeSession() {
        return super.getNativeSession();
    }

    public AsyncBatch createLoggedBatch() {
        log.debug("Spawn new Logged AsyncBatch");
        return new AsyncBatch(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext, BatchStatement.Type.LOGGED, false);
    }

    public AsyncBatch createUnloggedBatch() {
        log.debug("Spawn new Unlogged AsyncBatch");
        return new AsyncBatch(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext, BatchStatement.Type.UNLOGGED, false);
    }

    public AsyncBatch createOrderedLoggedBatch() {
        log.debug("Spawn new ordered Logged AsyncBatch");
        return new AsyncBatch(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext, BatchStatement.Type.LOGGED, true);
    }

    public AsyncBatch createOrderedUnloggedBatch() {
        log.debug("Spawn new ordered Unlogged AsyncBatch");
        return new AsyncBatch(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext, BatchStatement.Type.UNLOGGED, true);
    }
}

