/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.utils;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;

public class UUIDGen {
    private static final long START_EPOCH = -12219292800000L;
    private static final long clockSeqAndNode = UUIDGen.makeClockSeqAndNode();
    private static final UUIDGen instance = new UUIDGen();
    private long lastNanos;

    private UUIDGen() {
        if (clockSeqAndNode == 0L) {
            throw new RuntimeException("singleton instantiation is misplaced.");
        }
    }

    public static UUID getTimeUUID() {
        return new UUID(instance.createTimeSafe(), clockSeqAndNode);
    }

    public static long microsTimestamp(UUID uuid) {
        long timestamp = uuid.timestamp();
        long remainder = timestamp % 1000L;
        return timestamp / 10L + -12219292800000000L + remainder;
    }

    public static long increasingMicroTimestamp() {
        UUID timeUUID = UUIDGen.getTimeUUID();
        return UUIDGen.microsTimestamp(timeUUID);
    }

    private static long makeClockSeqAndNode() {
        long clock = new Random(System.currentTimeMillis()).nextLong();
        long lsb = 0L;
        lsb |= Long.MIN_VALUE;
        lsb |= (clock & 0x3FFFL) << 48;
        return lsb |= UUIDGen.makeNode();
    }

    private synchronized long createTimeSafe() {
        long nanosSince = (System.currentTimeMillis() - -12219292800000L) * 10000L;
        if (nanosSince > this.lastNanos) {
            this.lastNanos = nanosSince;
        } else {
            nanosSince = ++this.lastNanos;
        }
        return UUIDGen.createTime(nanosSince);
    }

    private static long createTime(long nanosSince) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & nanosSince) << 32;
        msb |= (0xFFFF00000000L & nanosSince) >>> 16;
        msb |= (0xFFFF000000000000L & nanosSince) >>> 48;
        return msb |= 0x1000L;
    }

    private static long makeNode() {
        Collection<InetAddress> localAddresses = UUIDGen.getAllLocalAddresses();
        if (localAddresses.isEmpty()) {
            throw new RuntimeException("Cannot generate the node component of the UUID because cannot retrieve any IP addresses.");
        }
        byte[] hash = UUIDGen.hash(localAddresses);
        long node = 0L;
        for (int i = 0; i < Math.min(6, hash.length); ++i) {
            node |= (0xFFL & (long)hash[i]) << (5 - i) * 8;
        }
        assert ((0xFF00000000000000L & node) == 0L);
        return node | 0x10000000000L;
    }

    private static byte[] hash(Collection<InetAddress> data) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            for (InetAddress addr : data) {
                messageDigest.update(addr.getAddress());
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("MD5 digest algorithm is not available", nsae);
        }
    }

    private static Collection<InetAddress> getAllLocalAddresses() {
        HashSet<InetAddress> localAddresses = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            if (nets != null) {
                while (nets.hasMoreElements()) {
                    localAddresses.addAll(Collections.list(nets.nextElement().getInetAddresses()));
                }
            }
        }
        catch (SocketException e) {
            throw new AssertionError((Object)e);
        }
        return localAddresses;
    }
}

