/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.internal.consistency.ConsistencyConverter;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.internal.statement.wrapper.NativeStatementWrapper;
import info.archinnov.achilles.listener.LWTResultListener;
import info.archinnov.achilles.type.ConsistencyLevel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class BatchStatementWrapper
extends AbstractStatementWrapper {
    private BatchStatement.Type batchType;
    private List<AbstractStatementWrapper> statementWrappers;
    private Optional<ConsistencyLevel> consistencyLevelO;
    private Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyLevelO;
    private Supplier<BatchStatement> batchStatement;
    private CompositeLWTResultListener compositeCASResultListener;

    public BatchStatementWrapper(final BatchStatement.Type batchType, final List<AbstractStatementWrapper> statementWrappers, Optional<ConsistencyLevel> consistencyLevelO, Optional<com.datastax.driver.core.ConsistencyLevel> serialConsistencyLevel) {
        super(null, null);
        this.batchType = batchType;
        this.statementWrappers = statementWrappers;
        this.consistencyLevelO = consistencyLevelO;
        this.serialConsistencyLevelO = serialConsistencyLevel;
        this.compositeCASResultListener = new CompositeLWTResultListener();
        this.lwtResultListener = Optional.fromNullable((Object)this.compositeCASResultListener);
        this.batchStatement = Suppliers.memoize((Supplier)new Supplier<BatchStatement>(){

            public BatchStatement get() {
                return BatchStatementWrapper.this.createBatchStatement(batchType, statementWrappers);
            }
        });
    }

    private BatchStatement createBatchStatement(BatchStatement.Type batchType, List<AbstractStatementWrapper> statementWrappers) {
        BatchStatement batch = new BatchStatement(batchType);
        boolean tracingEnabled = false;
        for (AbstractStatementWrapper statementWrapper : statementWrappers) {
            statementWrapper.activateQueryTracing();
            tracingEnabled |= statementWrapper.isTracingEnabled();
            if (statementWrapper.lwtResultListener.isPresent()) {
                this.compositeCASResultListener.addCASResultListener((LWTResultListener)statementWrapper.lwtResultListener.get());
            }
            if (statementWrapper instanceof NativeStatementWrapper) {
                batch.add(((NativeStatementWrapper)statementWrapper).buildParameterizedStatement());
                statementWrapper.releaseResources();
                continue;
            }
            batch.add(statementWrapper.getStatement());
            statementWrapper.releaseResources();
        }
        if (tracingEnabled) {
            batch.enableTracing();
        }
        if (this.consistencyLevelO.isPresent()) {
            batch.setConsistencyLevel(ConsistencyConverter.getCQLLevel((ConsistencyLevel)this.consistencyLevelO.get()));
        }
        if (this.serialConsistencyLevelO.isPresent()) {
            // empty if block
        }
        return batch;
    }

    @Override
    public String getQueryString() {
        ArrayList<String> queries = new ArrayList<String>();
        for (AbstractStatementWrapper statementWrapper : this.statementWrappers) {
            queries.add(statementWrapper.getQueryString());
        }
        return Joiner.on((String)"\n").join(queries);
    }

    @Override
    public ListenableFuture<ResultSet> executeAsync(Session session, ExecutorService executorService) {
        return super.executeAsyncInternal(session, this, executorService);
    }

    @Override
    public Statement getStatement() {
        return (Statement)this.batchStatement.get();
    }

    @Override
    public void logDMLStatement(String indentation) {
        BatchStatement batchStatement = (BatchStatement)this.batchStatement.get();
        if (dmlLogger.isDebugEnabled() || batchStatement.isTracing()) {
            AbstractStatementWrapper.writeDMLStartBatch(this.batchType);
        }
        for (AbstractStatementWrapper statementWrapper : this.statementWrappers) {
            statementWrapper.logDMLStatement(indentation);
        }
        if (dmlLogger.isDebugEnabled() || batchStatement.isTracing()) {
            ConsistencyLevel consistencyLevel = this.consistencyLevelO.isPresent() ? (ConsistencyLevel)this.consistencyLevelO.get() : null;
            AbstractStatementWrapper.writeDMLEndBatch(this.batchType, consistencyLevel);
        }
    }

    @Override
    public void releaseResources() {
    }

    public ConsistencyLevel getConsistencyLevel() {
        return (ConsistencyLevel)this.consistencyLevelO.get();
    }

    static class CompositeLWTResultListener
    implements LWTResultListener {
        private final Set<LWTResultListener> delegates = new HashSet<LWTResultListener>();

        CompositeLWTResultListener() {
        }

        private void addCASResultListener(LWTResultListener listener) {
            this.delegates.add(listener);
        }

        public void onSuccess() {
            for (LWTResultListener listener : this.delegates) {
                listener.onSuccess();
            }
        }

        public void onError(LWTResultListener.LWTResult lwtResult) {
            for (LWTResultListener listener : this.delegates) {
                listener.onError(lwtResult);
            }
        }
    }
}

