/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy.wrapper;

import com.google.common.base.Optional;
import info.archinnov.achilles.internal.proxy.wrapper.AbstractWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateListWrapper
extends AbstractWrapper
implements List<Object> {
    private static final Logger log = LoggerFactory.getLogger(UpdateListWrapper.class);

    @Override
    public boolean add(Object element) {
        log.trace("Mark list property {} of entity class {} dirty upon element addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Object rawElement = this.proxifier.removeProxy(element);
        this.getDirtyChecker().appendListElements(Arrays.asList(rawElement));
        return true;
    }

    @Override
    public boolean addAll(Collection<?> elements) {
        log.trace("Mark list property {} of entity class {} dirty upon elements addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Collection<?> rawElements = this.proxifier.removeProxy(elements);
        if (!rawElements.isEmpty()) {
            this.getDirtyChecker().appendListElements(new ArrayList<Object>(rawElements));
        }
        return true;
    }

    @Override
    public void add(int index, Object element) {
        log.trace("Mark list property {} of entity class {} dirty upon element addition at index {}", new Object[]{this.propertyMeta.getPropertyName(), this.propertyMeta.getEntityClassName(), index});
        if (index != 0) {
            throw new UnsupportedOperationException("Append, Prepend, Remove, RemoveAll and SetValueAtIndex are the only supported operations for CQL lists");
        }
        Object rawElement = this.proxifier.removeProxy(element);
        this.getDirtyChecker().prependListElements(Arrays.asList(rawElement));
    }

    @Override
    public boolean addAll(int index, Collection<?> elements) {
        if (index != 0) {
            throw new UnsupportedOperationException("Append, Prepend, Remove, RemoveAll and SetValueAtIndex are the only supported operations for CQL lists");
        }
        log.trace("Mark list property {} of entity class {} dirty upon elements addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Collection<?> rawElements = this.proxifier.removeProxy(elements);
        this.getDirtyChecker().prependListElements(new ArrayList<Object>(rawElements));
        return true;
    }

    @Override
    public void clear() {
        log.trace("Mark list property {} of entity class {} dirty upon clearance", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        this.getDirtyChecker().removeAllElements();
    }

    @Override
    public Object get(int index) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public int indexOf(Object arg0) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public int lastIndexOf(Object arg0) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public boolean contains(Object arg0) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public Iterator<Object> iterator() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public boolean remove(Object element) {
        log.trace("Mark list property {} of entity class {} dirty upon element removal", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Object rawElement = this.proxifier.removeProxy(element);
        this.getDirtyChecker().removeElements(Arrays.asList(rawElement));
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        log.trace("Mark list property {} of entity class {} dirty upon elements removal", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Collection<?> rawElements = this.proxifier.removeProxy(elements);
        this.getDirtyChecker().removeElements(new ArrayList<Object>(rawElements));
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }

    @Override
    public Object remove(int index) {
        log.trace("Mark list property {} of entity class {} dirty upon element removal at index {}", new Object[]{this.propertyMeta.getPropertyName(), this.propertyMeta.getEntityClassName(), index});
        this.getDirtyChecker().removeListElementAtIndex(index);
        return Optional.absent();
    }

    @Override
    public Object set(int index, Object element) {
        log.trace("Mark list property {} of entity class {} dirty upon element set at index {}", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Object rawElement = this.proxifier.removeProxy(element);
        this.getDirtyChecker().setListElementAtIndex(index, rawElement);
        return Optional.absent();
    }

    @Override
    public List<Object> subList(int from, int to) {
        throw new UnsupportedOperationException("This operation is not available on proxy objects for update. We don't want to read-before-write");
    }
}

