/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy.dirtycheck;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CollectionAndMapChangeType;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DirtyChecker {
    protected PropertyMeta propertyMeta;
    protected List<DirtyCheckChangeSet> changeSets = new ArrayList<DirtyCheckChangeSet>();
    public static final Predicate<DirtyChecker> SIMPLE_FIELD = new Predicate<DirtyChecker>(){

        public boolean apply(DirtyChecker dirtyChecker) {
            return dirtyChecker.isSimpleField();
        }
    };
    public static final Predicate<DirtyChecker> COLLECTION_AND_MAP_FIELD = new Predicate<DirtyChecker>(){

        public boolean apply(DirtyChecker dirtyChecker) {
            return !dirtyChecker.isSimpleField();
        }
    };
    public static final Function<DirtyChecker, PropertyMeta> EXTRACT_META = new Function<DirtyChecker, PropertyMeta>(){

        public PropertyMeta apply(DirtyChecker dirtyChecker) {
            return dirtyChecker.propertyMeta;
        }
    };

    public DirtyChecker(PropertyMeta propertyMeta) {
        this.propertyMeta = propertyMeta;
    }

    public boolean isSimpleField() {
        return false;
    }

    public PropertyMeta getPropertyMeta() {
        return this.propertyMeta;
    }

    public List<DirtyCheckChangeSet> getChangeSets() {
        return this.changeSets;
    }

    public void assignValue(List<Object> elements) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.ASSIGN_VALUE_TO_LIST);
        changeSet.setListChanges(elements);
        this.changeSets.add(changeSet);
    }

    public void assignValue(Set<Object> elements) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.ASSIGN_VALUE_TO_SET);
        changeSet.setSetChanges(elements);
        this.changeSets.add(changeSet);
    }

    public void assignValue(Map<Object, Object> entries) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.ASSIGN_VALUE_TO_MAP);
        changeSet.setMapChanges(entries);
        this.changeSets.add(changeSet);
    }

    public void removeAllElements() {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.REMOVE_COLLECTION_OR_MAP);
        this.changeSets.add(changeSet);
    }

    public void addElements(Set<Object> elements) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.ADD_TO_SET);
        changeSet.setSetChanges(elements);
        this.changeSets.add(changeSet);
    }

    public void removeElements(Set<Object> elements) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.REMOVE_FROM_SET);
        changeSet.setSetChanges(elements);
        this.changeSets.add(changeSet);
    }

    public void appendListElements(List<Object> elements) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.APPEND_TO_LIST);
        changeSet.setListChanges(elements);
        this.changeSets.add(changeSet);
    }

    public void prependListElements(List<Object> elements) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.PREPEND_TO_LIST);
        changeSet.setListChanges(elements);
        this.changeSets.add(changeSet);
    }

    public void removeElements(List<Object> elements) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.REMOVE_FROM_LIST);
        changeSet.setListChanges(elements);
        this.changeSets.add(changeSet);
    }

    public void setListElementAtIndex(int index, Object element) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.SET_TO_LIST_AT_INDEX);
        changeSet.setListChangeAtIndex(new DirtyCheckChangeSet.ElementAtIndex(index, element));
        this.changeSets.add(changeSet);
    }

    public void removeListElementAtIndex(int index) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.REMOVE_FROM_LIST_AT_INDEX);
        changeSet.setListChangeAtIndex(new DirtyCheckChangeSet.ElementAtIndex(index, null));
        this.changeSets.add(changeSet);
    }

    public void addElements(Map<Object, Object> entries) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.ADD_TO_MAP);
        changeSet.setMapChanges(entries);
        this.changeSets.add(changeSet);
    }

    public void removeMapEntry(Object key) {
        DirtyCheckChangeSet changeSet = new DirtyCheckChangeSet(this.propertyMeta, CollectionAndMapChangeType.REMOVE_FROM_MAP);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(key, null);
        changeSet.setMapChanges(map);
        this.changeSets.add(changeSet);
    }
}

