/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy;

import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.InternalCounterBuilder;
import info.archinnov.achilles.internal.proxy.AchillesProxyInterceptor;
import info.archinnov.achilles.internal.proxy.ProxySerializable;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyChecker;
import info.archinnov.achilles.internal.proxy.dirtycheck.SimpleDirtyChecker;
import info.archinnov.achilles.internal.proxy.wrapper.builder.UpdateListWrapperBuilder;
import info.archinnov.achilles.internal.proxy.wrapper.builder.UpdateMapWrapperBuilder;
import info.archinnov.achilles.internal.proxy.wrapper.builder.UpdateSetWrapperBuilder;
import info.archinnov.achilles.internal.reflection.ReflectionInvoker;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateProxyInterceptor<T>
implements MethodInterceptor,
ProxySerializable,
AchillesProxyInterceptor<T> {
    private static final transient Logger log = LoggerFactory.getLogger(UpdateProxyInterceptor.class);
    private transient ReflectionInvoker invoker = ReflectionInvoker.Singleton.INSTANCE.get();
    private transient T target;
    private transient Object primaryKey;
    private transient Method idGetter;
    private transient Method idSetter;
    private transient Map<Method, PropertyMeta> getterMetas;
    private transient Map<Method, PropertyMeta> setterMetas;
    private transient Map<Method, DirtyChecker> dirtyMap;
    private transient EntityOperations context;

    @Override
    public Object getTarget() {
        return this.target;
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        log.trace("Method {} called for entity of class {}", (Object)method.getName(), (Object)this.target.getClass().getCanonicalName());
        if (this.idGetter.equals(method)) {
            return this.primaryKey;
        }
        if (this.idSetter.equals(method)) {
            throw new IllegalAccessException("Cannot change primary key value for existing entity ");
        }
        Object result = null;
        if (this.getterMetas.containsKey(method)) {
            result = this.interceptGetter(method);
        } else if (this.setterMetas.containsKey(method)) {
            this.interceptSetter(method, obj, args);
        } else {
            result = proxy.invoke(this.target, args);
        }
        return result;
    }

    private Object interceptGetter(Method method) throws Throwable {
        Object result;
        PropertyMeta propertyMeta = this.getterMetas.get(method);
        log.trace("Get value from field {} on real object", (Object)propertyMeta.getPropertyName());
        switch (propertyMeta.type()) {
            case COUNTER: {
                Object counter = propertyMeta.forValues().getValueFromField(this.target);
                if (counter == null) {
                    counter = InternalCounterBuilder.initialValue(null);
                    propertyMeta.forValues().setValueToField(this.target, counter);
                }
                result = counter;
                break;
            }
            case LIST: {
                log.trace("Build update list wrapper for property {} of entity of class {} ", (Object)propertyMeta.getPropertyName(), (Object)propertyMeta.getEntityClassName());
                result = ((UpdateListWrapperBuilder)((UpdateListWrapperBuilder)((UpdateListWrapperBuilder)UpdateListWrapperBuilder.builder().dirtyMap(this.dirtyMap)).setter(propertyMeta.getSetter())).propertyMeta(this.getPropertyMetaByProperty(method))).build();
                break;
            }
            case SET: {
                log.trace("Build update set wrapper for property {} of entity of class {} ", (Object)propertyMeta.getPropertyName(), (Object)propertyMeta.getEntityClassName());
                result = ((UpdateSetWrapperBuilder)((UpdateSetWrapperBuilder)((UpdateSetWrapperBuilder)UpdateSetWrapperBuilder.builder().dirtyMap(this.dirtyMap)).setter(propertyMeta.getSetter())).propertyMeta(this.getPropertyMetaByProperty(method))).build();
                break;
            }
            case MAP: {
                log.trace("Build update map wrapper for property {} of entity of class {} ", (Object)propertyMeta.getPropertyName(), (Object)propertyMeta.getEntityClassName());
                result = ((UpdateMapWrapperBuilder)((UpdateMapWrapperBuilder)((UpdateMapWrapperBuilder)UpdateMapWrapperBuilder.builder().dirtyMap(this.dirtyMap)).setter(propertyMeta.getSetter())).propertyMeta(this.getPropertyMetaByProperty(method))).build();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot call getter on non collection/map method. This proxy object is for update only, lazy-loading is not supported");
            }
        }
        return result;
    }

    private void interceptSetter(Method method, Object obj, Object[] args) throws Throwable {
        PropertyMeta propertyMeta = this.setterMetas.get(method);
        DirtyChecker dirtyChecker = null;
        boolean removeField = false;
        if (args[0] == null) {
            removeField = true;
        }
        switch (propertyMeta.type()) {
            case SIMPLE: {
                dirtyChecker = new SimpleDirtyChecker(propertyMeta);
                break;
            }
            case SET: {
                dirtyChecker = new DirtyChecker(propertyMeta);
                if (removeField) {
                    dirtyChecker.removeAllElements();
                    break;
                }
                dirtyChecker.assignValue((Set)args[0]);
                break;
            }
            case LIST: {
                dirtyChecker = new DirtyChecker(propertyMeta);
                if (removeField) {
                    dirtyChecker.removeAllElements();
                    break;
                }
                dirtyChecker.assignValue((List)args[0]);
                break;
            }
            case MAP: {
                dirtyChecker = new DirtyChecker(propertyMeta);
                if (removeField) {
                    dirtyChecker.removeAllElements();
                    break;
                }
                dirtyChecker.assignValue((Map)args[0]);
                break;
            }
            case COUNTER: {
                throw new UnsupportedOperationException("Cannot set value directly to a Counter type. Please call the getter first to get handle on the wrapper");
            }
        }
        log.trace("Flagging property {}", (Object)propertyMeta.getPropertyName());
        this.dirtyMap.put(method, dirtyChecker);
        Object value = null;
        if (args.length > 0) {
            value = args[0];
        }
        propertyMeta.forValues().setValueToField(this.target, value);
    }

    @Override
    public Object writeReplace() {
        return this.target;
    }

    @Override
    public Map<Method, DirtyChecker> getDirtyMap() {
        return this.dirtyMap;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    @Override
    public void setTarget(T target) {
        this.target = target;
    }

    void setPrimaryKey(Object key) {
        this.primaryKey = key;
    }

    void setIdGetter(Method idGetter) {
        this.idGetter = idGetter;
    }

    void setIdSetter(Method idSetter) {
        this.idSetter = idSetter;
    }

    void setGetterMetas(Map<Method, PropertyMeta> getterMetas) {
        this.getterMetas = getterMetas;
    }

    void setSetterMetas(Map<Method, PropertyMeta> setterMetas) {
        this.setterMetas = setterMetas;
    }

    @Override
    public void setDirtyMap(Map<Method, DirtyChecker> dirtyMap) {
        this.dirtyMap = dirtyMap;
    }

    public EntityOperations getEntityOperations() {
        return this.context;
    }

    @Override
    public void setEntityOperations(EntityOperations context) {
        this.context = context;
    }

    @Override
    public Set<Method> getAlreadyLoaded() {
        throw new UnsupportedOperationException("Operation not supported by proxy for update");
    }

    private PropertyMeta getPropertyMetaByProperty(Method method) {
        return this.getterMetas.get(method);
    }
}

