/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy;

import info.archinnov.achilles.internal.context.ConfigurationContext;
import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.NoOp;

public class ProxyClassFactory {
    private static final int NO_OP_CALLBACK_INDEX = 1;
    private static final int METHOD_INTERCEPTOR_CALLBACK_INDEX = 0;
    public static final Class[] CALLBACK_TYPES = new Class[]{MethodInterceptor.class, NoOp.class};
    public static final CallbackFilter INTERCEPT_ALL_BUT_FINALIZE = new CallbackFilter(){

        public int accept(Method method) {
            return this.isFinalizeMethod(method) ? 1 : 0;
        }

        private boolean isFinalizeMethod(Method method) {
            return method.getName().equals("finalize") && method.getReturnType().equals(Void.TYPE) && method.getParameterTypes().length == 0;
        }
    };

    public Class<?> createProxyClass(Class<?> entityClass, ConfigurationContext configContext) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(entityClass);
        enhancer.setInterfaces(new Class[]{Serializable.class});
        enhancer.setClassLoader(configContext.selectClassLoader(entityClass));
        enhancer.setUseCache(true);
        enhancer.setCallbackTypes(CALLBACK_TYPES);
        enhancer.setCallbackFilter(INTERCEPT_ALL_BUT_FINALIZE);
        enhancer.setUseFactory(true);
        return enhancer.createClass();
    }

    public static enum Singleton {
        INSTANCE;

        private final ProxyClassFactory instance = new ProxyClassFactory();

        public ProxyClassFactory get() {
            return this.instance;
        }
    }
}

