/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ListenableFuture;
import info.archinnov.achilles.async.AchillesFuture;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.async.AsyncUtils;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityMapper;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.statement.wrapper.BoundStatementWrapper;
import info.archinnov.achilles.iterator.AchillesIterator;
import info.archinnov.achilles.query.slice.SliceQueryProperties;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Empty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(SliceQueryExecutor.class);
    protected EntityMapper mapper = EntityMapper.Singleton.INSTANCE.get();
    protected EntityProxifier proxifier = EntityProxifier.Singleton.INSTANCE.get();
    protected AsyncUtils asyncUtils = AsyncUtils.Singleton.INSTANCE.get();
    protected PersistenceContextFactory contextFactory;
    protected DaoContext daoContext;
    protected ExecutorService executorService;

    public SliceQueryExecutor(PersistenceContextFactory contextFactory, ConfigurationContext configContext, DaoContext daoContext) {
        this.contextFactory = contextFactory;
        this.daoContext = daoContext;
        this.executorService = configContext.getExecutorService();
    }

    public <T> List<T> get(SliceQueryProperties<T> sliceQueryProperties) {
        return this.asyncGet(sliceQueryProperties).getImmediately();
    }

    public <T> AchillesFuture<List<T>> asyncGet(SliceQueryProperties<T> sliceQueryProperties) {
        log.debug("Get slice query");
        ListenableFuture<List<T>> futureEntities = this.coreAsyncGet(sliceQueryProperties);
        return this.asyncUtils.buildInterruptible(futureEntities);
    }

    public <T> AchillesFuture<T> asyncGetOne(SliceQueryProperties<T> sliceQueryProperties) {
        log.debug("Get slice query");
        Function takeFirstFunction = new Function<List<T>, T>(){

            public T apply(List<T> result) {
                if (result.isEmpty()) {
                    return null;
                }
                return result.get(0);
            }
        };
        ListenableFuture<List<T>> futureEntities = this.coreAsyncGet(sliceQueryProperties);
        ListenableFuture futureEntity = this.asyncUtils.transformFuture(futureEntities, takeFirstFunction);
        return this.asyncUtils.buildInterruptible(futureEntity);
    }

    protected <T> ListenableFuture<List<T>> coreAsyncGet(final SliceQueryProperties<T> sliceQueryProperties) {
        final EntityMeta meta = sliceQueryProperties.getEntityMeta();
        BoundStatementWrapper bsWrapper = this.daoContext.bindForSliceQuerySelect(sliceQueryProperties);
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(bsWrapper);
        ListenableFuture<List<Row>> futureRows = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ROWS);
        Function rowsToEntities = new Function<List<Row>, List<T>>(){

            public List<T> apply(List<Row> rows) {
                ArrayList clusteredEntities = new ArrayList();
                for (Row row : rows) {
                    Object clusteredEntity = meta.forOperations().instanciate();
                    SliceQueryExecutor.this.mapper.setNonCounterPropertiesToEntity(row, meta, clusteredEntity, sliceQueryProperties.shouldCreateProxy() ? EntityMeta.EntityState.MANAGED : EntityMeta.EntityState.NOT_MANAGED);
                    if (!sliceQueryProperties.shouldCreateProxy()) {
                        SliceQueryExecutor.this.mapper.setValuesToClusteredCounterEntity(row, meta, clusteredEntity);
                    }
                    meta.forInterception().intercept(clusteredEntity, Event.POST_LOAD);
                    clusteredEntities.add(clusteredEntity);
                }
                return clusteredEntities;
            }
        };
        ListenableFuture futureEntities = this.asyncUtils.transformFuture(futureRows, rowsToEntities);
        this.asyncUtils.maybeAddAsyncListeners(futureEntities, sliceQueryProperties.getAsyncListeners());
        if (sliceQueryProperties.shouldCreateProxy()) {
            return this.asyncUtils.transformFuture(futureEntities, this.getProxyListTransformer());
        }
        return futureEntities;
    }

    public <T> Iterator<T> iterator(SliceQueryProperties<T> sliceQueryProperties) {
        log.debug("Get iterator for slice query");
        return this.asyncIterator(sliceQueryProperties).getImmediately();
    }

    public <T> AchillesFuture<Iterator<T>> asyncIterator(final SliceQueryProperties<T> sliceQueryProperties) {
        log.debug("Get iterator for slice query asynchronously");
        BoundStatementWrapper bsWrapper = this.daoContext.bindForSliceQuerySelect(sliceQueryProperties);
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(bsWrapper);
        ListenableFuture<Iterator<Row>> futureIterator = this.asyncUtils.transformFuture(resultSetFuture, AsyncUtils.RESULTSET_TO_ITERATOR);
        Function rowToIterator = new Function<Iterator<Row>, Iterator<T>>(){

            public Iterator<T> apply(Iterator<Row> rowIterator) {
                PersistenceContext context = SliceQueryExecutor.this.buildContextForQuery(sliceQueryProperties);
                return new AchillesIterator(sliceQueryProperties.getEntityMeta(), sliceQueryProperties.shouldCreateProxy(), context, rowIterator);
            }
        };
        ListenableFuture listenableFuture = this.asyncUtils.transformFuture(futureIterator, rowToIterator);
        this.asyncUtils.maybeAddAsyncListeners(listenableFuture, sliceQueryProperties.getAsyncListeners());
        return this.asyncUtils.buildInterruptible(listenableFuture);
    }

    public <T> void delete(SliceQueryProperties<T> sliceQueryProperties) {
        this.asyncDelete(sliceQueryProperties).getImmediately();
    }

    public <T> AchillesFuture<Empty> asyncDelete(SliceQueryProperties<T> sliceQueryProperties) {
        log.debug("Slice delete");
        BoundStatementWrapper bsWrapper = this.daoContext.bindForSliceQueryDelete(sliceQueryProperties);
        ListenableFuture<ResultSet> resultSetFuture = this.daoContext.execute(bsWrapper);
        ListenableFuture<Empty> listenableFuture = this.asyncUtils.transformFutureToEmpty(resultSetFuture, this.executorService);
        this.asyncUtils.maybeAddAsyncListeners(listenableFuture, sliceQueryProperties.getAsyncListeners(), this.executorService);
        return this.asyncUtils.buildInterruptible(listenableFuture);
    }

    protected <T> PersistenceContext buildContextForQuery(SliceQueryProperties<T> sliceQueryProperties) {
        log.trace("Build PersistenceContext for slice query");
        ConsistencyLevel cl = sliceQueryProperties.getReadConsistencyLevel();
        return this.contextFactory.newContextForSliceQuery(sliceQueryProperties.getEntityClass(), sliceQueryProperties.getPartitionKeys(), cl);
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    private <T> Function<List<T>, List<T>> getProxyListTransformer() {
        return new Function<List<T>, List<T>>(){

            public List<T> apply(List<T> clusteredEntities) {
                ArrayList proxies = new ArrayList();
                for (Object clusteredEntity : clusteredEntities) {
                    PersistenceContext context = SliceQueryExecutor.this.contextFactory.newContext(clusteredEntity);
                    proxies.add(SliceQueryExecutor.this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(clusteredEntity, context.getEntityFacade()));
                }
                return proxies;
            }
        };
    }
}

