/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import com.google.common.base.Predicate;
import info.archinnov.achilles.annotations.ClusteringColumn;
import info.archinnov.achilles.annotations.Column;
import info.archinnov.achilles.annotations.Order;
import info.archinnov.achilles.annotations.PartitionKey;
import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.internal.metadata.parsing.DefaultComponentOrderingParser;
import info.archinnov.achilles.internal.metadata.parsing.EntityIntrospector;
import info.archinnov.achilles.internal.metadata.parsing.LegacyComponentOrderingParser;
import info.archinnov.achilles.internal.metadata.parsing.context.PropertyParsingContext;
import info.archinnov.achilles.schemabuilder.Create;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reflections.ReflectionUtils;

public abstract class ComponentOrderingParser {
    protected EntityIntrospector introspector = EntityIntrospector.Singleton.INSTANCE.get();
    protected PropertyParsingContext context;

    public static ComponentOrderingParser determineAppropriateParser(Class<?> compoundPKClass, PropertyParsingContext context) {
        Set partitionKeyAnnotations = ReflectionUtils.getAllFields(compoundPKClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(PartitionKey.class)});
        Set clusteringColumnAnnotations = ReflectionUtils.getAllFields(compoundPKClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(ClusteringColumn.class)});
        Set orderAnnotations = ReflectionUtils.getAllFields(compoundPKClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Order.class)});
        if (clusteringColumnAnnotations.size() > 0 && orderAnnotations.size() > 0) {
            throw new AchillesBeanMappingException(String.format("You should stop using the deprecated @Order annotation in favor of @PartitionKey and @ClusteringColumn for the @CompoundPrimaryKey class '%s'", compoundPKClass.getCanonicalName()));
        }
        if (clusteringColumnAnnotations.size() + orderAnnotations.size() + partitionKeyAnnotations.size() == 0) {
            throw new AchillesBeanMappingException(String.format("Please use @PartitionKey and @ClusteringColumn annotations for the @CompoundPrimaryKey class '%s'", compoundPKClass.getCanonicalName()));
        }
        if (orderAnnotations.size() > 0) {
            return new LegacyComponentOrderingParser(context);
        }
        return new DefaultComponentOrderingParser(context);
    }

    public ComponentOrderingParser(PropertyParsingContext context) {
        this.context = context;
    }

    abstract Map<Integer, Field> extractComponentsOrdering(Class<?> var1);

    abstract List<Create.Options.ClusteringOrder> extractClusteringOrder(Class<?> var1);

    protected void validateNotStaticColumn(Field field) {
        Column column = field.getAnnotation(Column.class);
        if (column != null && column.staticColumn()) {
            throw new AchillesBeanMappingException(String.format("The property '%s' of class '%s' cannot be a static column because it belongs to the primary key", field.getName(), field.getDeclaringClass().getCanonicalName()));
        }
    }
}

