/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.internal.metadata.util.PropertyTypeExclude;
import info.archinnov.achilles.internal.metadata.util.PropertyTypeFilter;

public enum PropertyType {
    PARTITION_KEY,
    COMPOUND_PRIMARY_KEY,
    SIMPLE,
    LIST,
    SET,
    MAP,
    COUNTER;

    public static final PropertyTypeFilter COUNTER_TYPE;
    public static final PropertyTypeFilter COMPOUND_PK_TYPE;
    public static final PropertyTypeExclude EXCLUDE_ID_TYPES;
    public static final PropertyTypeExclude EXCLUDE_COMPOUND_PK_TYPE;
    public static final PropertyTypeExclude EXCLUDE_COUNTER_TYPE;
    public static final PropertyTypeExclude EXCLUDE_PK_AND_COUNTER_TYPE;

    public boolean isCounter() {
        return this == COUNTER;
    }

    public boolean isPrimaryKey() {
        return this == PARTITION_KEY || this == COMPOUND_PRIMARY_KEY;
    }

    public boolean isCompoundPK() {
        return this == COMPOUND_PRIMARY_KEY;
    }

    public boolean isValidClusteredValueType() {
        return this == SIMPLE || this == COUNTER;
    }

    public boolean isCollectionAndMap() {
        return this == LIST || this == SET || this == MAP;
    }

    static {
        COUNTER_TYPE = new PropertyTypeFilter(COUNTER);
        COMPOUND_PK_TYPE = new PropertyTypeFilter(COMPOUND_PRIMARY_KEY);
        EXCLUDE_ID_TYPES = new PropertyTypeExclude(PARTITION_KEY, COMPOUND_PRIMARY_KEY);
        EXCLUDE_COMPOUND_PK_TYPE = new PropertyTypeExclude(COMPOUND_PRIMARY_KEY);
        EXCLUDE_COUNTER_TYPE = new PropertyTypeExclude(COUNTER);
        EXCLUDE_PK_AND_COUNTER_TYPE = new PropertyTypeExclude(PARTITION_KEY, COMPOUND_PRIMARY_KEY, COUNTER);
    }
}

