/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaView;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaTypedQuery
extends PropertyMetaView {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaTypedQuery.class);
    private static final Pattern SELECT_COLUMNS_PATTERN = Pattern.compile("select (.+) from .+");

    protected PropertyMetaTypedQuery(PropertyMeta meta) {
        super(meta);
    }

    public void validateTypedQuery(String queryString, List<String> staticColumns) {
        log.trace("Validate typed query string {} for entity class {}", (Object)queryString, (Object)this.meta.getEntityClassName());
        boolean hasStaticColumns = false;
        Matcher matcher = SELECT_COLUMNS_PATTERN.matcher(queryString);
        if (matcher.matches()) {
            for (String column : matcher.group(1).split(",")) {
                if (!staticColumns.contains(column.trim())) continue;
                hasStaticColumns = true;
                break;
            }
        }
        if (this.meta.structure().isCompoundPK()) {
            if (hasStaticColumns) {
                for (String component : this.meta.getCompoundPKProperties().getPartitionComponents().getCQLComponentNames()) {
                    Validator.validateTrue(queryString.contains(component), "The typed query [%s] should contain the partition key component '%s' for compound primary key type '%s'", queryString, component, this.meta.getValueClass().getCanonicalName());
                }
            } else {
                for (String component : this.meta.getCompoundPKProperties().getCQLComponentNames()) {
                    Validator.validateTrue(queryString.contains(component), "The typed query [%s] should contain the component column '%s' for compound primary key type '%s'", queryString, component, this.meta.getValueClass().getCanonicalName());
                }
            }
        } else {
            Validator.validateTrue(queryString.contains(this.meta.getCQLColumnName()), "The typed query [%s] should contain the id column '%s'", queryString, this.meta.getCQLColumnName());
        }
    }
}

