/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.internal.cql.TypeMapper;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMetaView;
import info.archinnov.achilles.internal.table.SchemaNameNormalizer;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import info.archinnov.achilles.schemabuilder.SchemaBuilder;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaTableCreator
extends PropertyMetaView {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaTableCreator.class);

    protected PropertyMetaTableCreator(PropertyMeta meta) {
        super(meta);
    }

    public void addPartitionKeys(Create createTable) {
        log.debug("Adding partition keys {} for entity class {}", this.meta.getCompoundPKProperties().getPartitionComponents().getCQLComponentNames(), (Object)this.meta.getEntityClassName());
        Validator.validateNotNull(this.meta.getCompoundPKProperties(), "Cannot create partition components for entity '%s' because it does not have a compound primary key", this.meta.getEntityClassName());
        for (PropertyMeta partitionMeta : this.meta.getCompoundPKProperties().getPartitionComponents().propertyMetas) {
            String cqlColumnName = partitionMeta.getCQLColumnName();
            Class javaType = partitionMeta.structure().getCQLValueType();
            createTable.addPartitionKey(cqlColumnName, TypeMapper.toCQLDataType(javaType));
        }
    }

    public void addClusteringKeys(Create createTable) {
        log.debug("Adding clustering keys {} for entity class {}", this.meta.getCompoundPKProperties().getClusteringComponents().getCQLComponentNames(), (Object)this.meta.getEntityClassName());
        Validator.validateNotNull(this.meta.getCompoundPKProperties(), "Cannot create clustering keys for entity '%s' because it does not have a compound primary key", this.meta.getEntityClassName());
        for (PropertyMeta clusteringMeta : this.meta.getCompoundPKProperties().getClusteringComponents().propertyMetas) {
            String cqlColumnName = clusteringMeta.getCQLColumnName();
            Class javaType = clusteringMeta.structure().getCQLValueType();
            createTable.addClusteringKey(cqlColumnName, TypeMapper.toCQLDataType(javaType));
        }
    }

    public String createNewIndexScript(String tableName) {
        Validator.validateNotNull(this.meta.getIndexProperties(), "Cannot create new index script on property {} of entity {} because it is not defined as indexed", this.meta.propertyName, this.meta.getEntityClassName());
        log.debug("Creating new index {} for table {}", (Object)this.meta.getIndexProperties().getIndexName(), (Object)tableName);
        String optionalIndexName = this.meta.getIndexProperties().getIndexName();
        String cqlColumnName = this.meta.getCQLColumnName();
        String indexName = StringUtils.isBlank((CharSequence)optionalIndexName) ? this.buildValidIndexNameWithRegardToCase(tableName, cqlColumnName) : optionalIndexName.replaceAll("\"", "");
        return SchemaBuilder.createIndex(indexName).onTable(tableName).andColumn(cqlColumnName);
    }

    public Create.Options addClusteringOrder(Create.Options tableOptions) {
        if (this.meta.structure().isClustered()) {
            List<Create.Options.ClusteringOrder> clusteringOrders = this.meta.getCompoundPKProperties().getClusteringComponents().getClusteringOrders();
            log.debug("Add clustering orders {} to entity class {}", clusteringOrders, (Object)this.meta.getEntityClassName());
            return tableOptions.clusteringOrder(clusteringOrders.toArray(new Create.Options.ClusteringOrder[clusteringOrders.size()]));
        }
        return tableOptions;
    }

    private String buildValidIndexNameWithRegardToCase(String tableName, String cqlColumnName) {
        if (SchemaNameNormalizer.isCaseSensitive(tableName) || SchemaNameNormalizer.isCaseSensitive(cqlColumnName)) {
            return tableName.replaceAll("\"", "") + "_" + cqlColumnName.replaceAll("\"", "") + "_idx";
        }
        return tableName + "_" + cqlColumnName + "_idx";
    }
}

