/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.codec;

import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.exception.AchillesTranscodingException;
import info.archinnov.achilles.internal.metadata.codec.MapCodec;
import java.util.HashMap;
import java.util.Map;

public class MapCodecImpl<FROM_KEY, FROM_VAL, TO_KEY, TO_VAL>
implements MapCodec<FROM_KEY, FROM_VAL, TO_KEY, TO_VAL> {
    private final Class<FROM_KEY> sourceKeyType;
    private final Class<FROM_VAL> sourceValueType;
    private final Class<TO_KEY> targetKeyType;
    private final Class<TO_VAL> targetValueType;
    private final Codec<FROM_KEY, TO_KEY> keyCodec;
    private final Codec<FROM_VAL, TO_VAL> valueCodec;

    MapCodecImpl(Class<FROM_KEY> sourceKeyType, Class<FROM_VAL> sourceValueType, Class<TO_KEY> targetKeyType, Class<TO_VAL> targetValueType, Codec<FROM_KEY, TO_KEY> keyCodec, Codec<FROM_VAL, TO_VAL> valueCodec) {
        this.sourceKeyType = sourceKeyType;
        this.sourceValueType = sourceValueType;
        this.targetKeyType = targetKeyType;
        this.targetValueType = targetValueType;
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
    }

    @Override
    public Class<FROM_KEY> sourceKeyType() {
        return this.sourceKeyType;
    }

    @Override
    public Class<FROM_VAL> sourceValueType() {
        return this.sourceValueType;
    }

    @Override
    public Class<TO_KEY> targetKeyType() {
        return this.targetKeyType;
    }

    @Override
    public Class<TO_VAL> targetValueType() {
        return this.targetValueType;
    }

    @Override
    public Map<TO_KEY, TO_VAL> encode(Map<FROM_KEY, FROM_VAL> fromJava) throws AchillesTranscodingException {
        if (fromJava == null) {
            return null;
        }
        HashMap<Object, Object> encoded = new HashMap<Object, Object>();
        for (Map.Entry<FROM_KEY, FROM_VAL> source : fromJava.entrySet()) {
            encoded.put(this.keyCodec.encode(source.getKey()), this.valueCodec.encode(source.getValue()));
        }
        return encoded;
    }

    @Override
    public Map<FROM_KEY, FROM_VAL> decode(Map<TO_KEY, TO_VAL> fromCassandra) throws AchillesTranscodingException {
        if (fromCassandra == null) {
            return null;
        }
        HashMap<Object, Object> decoded = new HashMap<Object, Object>();
        for (Map.Entry<TO_KEY, TO_VAL> source : fromCassandra.entrySet()) {
            decoded.put(this.keyCodec.decode(source.getKey()), this.valueCodec.decode(source.getValue()));
        }
        return decoded;
    }
}

