/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.codec;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.codec.Codec;
import info.archinnov.achilles.exception.AchillesTranscodingException;
import java.io.IOException;

public class JSONCodec<TYPE>
implements Codec<TYPE, String> {
    private final Class<TYPE> sourceType;
    private final ObjectMapper objectMapper;

    public JSONCodec(ObjectMapper objectMapper, Class<TYPE> sourceType) {
        this.sourceType = sourceType;
        this.objectMapper = objectMapper;
    }

    public Class<TYPE> sourceType() {
        return this.sourceType;
    }

    public Class<String> targetType() {
        return String.class;
    }

    public String encode(TYPE fromJava) throws AchillesTranscodingException {
        if (fromJava == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString(fromJava);
        }
        catch (JsonProcessingException e) {
            throw new AchillesTranscodingException((Throwable)e);
        }
    }

    public TYPE decode(String fromCassandra) throws AchillesTranscodingException {
        if (fromCassandra == null) {
            return null;
        }
        try {
            return (TYPE)this.objectMapper.readValue(fromCassandra, this.sourceType);
        }
        catch (IOException e) {
            throw new AchillesTranscodingException((Throwable)e);
        }
    }

    public static <TYPE> JSONCodec<TYPE> create(ObjectMapper objectMapper, Class<TYPE> sourceType) {
        return new JSONCodec<TYPE>(objectMapper, sourceType);
    }
}

