/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import info.archinnov.achilles.counter.AchillesCounter;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.parsing.context.ParsingResult;
import info.archinnov.achilles.internal.statement.cache.CacheManager;
import info.archinnov.achilles.internal.statement.cache.StatementCacheKey;
import info.archinnov.achilles.internal.statement.prepared.PreparedStatementGenerator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoContextFactory {
    private static final Logger log = LoggerFactory.getLogger(DaoContextFactory.class);
    private PreparedStatementGenerator queryGenerator = PreparedStatementGenerator.Singleton.INSTANCE.get();

    public DaoContext create(Session session, ParsingResult parsingResult, ConfigurationContext configContext) {
        log.debug("Build DaoContext");
        Map<Class<?>, EntityMeta> metaMap = parsingResult.getMetaMap();
        HashMap selectPSMap = new HashMap(Maps.transformValues(metaMap, this.getSelectPSTransformer(session)));
        Cache dynamicPSCache = CacheBuilder.newBuilder().maximumSize((long)configContext.getPreparedStatementLRUCacheSize()).build();
        Object counterQueryMap = parsingResult.hasSimpleCounter() ? this.queryGenerator.prepareSimpleCounterQueryMap(session) : ImmutableMap.of();
        HashMap clusteredCounterQueriesMap = new HashMap(Maps.transformValues((Map)Maps.filterValues(metaMap, EntityMeta.CLUSTERED_COUNTER_FILTER), this.getClusteredCounterTransformer(session)));
        this.displayPreparedStatementsStats(selectPSMap, (Map<AchillesCounter.CQLQueryType, PreparedStatement>)counterQueryMap, clusteredCounterQueriesMap);
        DaoContext daoContext = new DaoContext();
        daoContext.setDynamicPSCache((Cache<StatementCacheKey, PreparedStatement>)dynamicPSCache);
        daoContext.setSelectPSs(selectPSMap);
        daoContext.setCounterQueryMap((Map<AchillesCounter.CQLQueryType, PreparedStatement>)counterQueryMap);
        daoContext.setClusteredCounterQueryMap(clusteredCounterQueriesMap);
        daoContext.setSession(session);
        daoContext.setCacheManager(new CacheManager(configContext.getPreparedStatementLRUCacheSize()));
        daoContext.setExecutorService(configContext.getExecutorService());
        return daoContext;
    }

    Function<EntityMeta, PreparedStatement> getSelectPSTransformer(final Session session) {
        return new Function<EntityMeta, PreparedStatement>(){

            public PreparedStatement apply(EntityMeta meta) {
                return DaoContextFactory.this.queryGenerator.prepareSelectAll(session, meta);
            }
        };
    }

    Function<EntityMeta, Map<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>>> getClusteredCounterTransformer(final Session session) {
        return new Function<EntityMeta, Map<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>>>(){

            public Map<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>> apply(EntityMeta meta) {
                return DaoContextFactory.this.queryGenerator.prepareClusteredCounterQueryMap(session, meta);
            }
        };
    }

    private void displayPreparedStatementsStats(Map<Class<?>, PreparedStatement> selectPSMap, Map<AchillesCounter.CQLQueryType, PreparedStatement> counterQueryMap, Map<Class<?>, Map<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>>> clusteredCounterQueriesMap) {
        log.info("Prepare {} SELECT, {} COUNTER SELECT and {} CLUSTERED COUNTER SELECT statements", new Object[]{selectPSMap.size(), counterQueryMap.size(), clusteredCounterQueriesMap.size()});
        int totalPreparedStatementsCount = selectPSMap.size() + counterQueryMap.size() + clusteredCounterQueriesMap.size();
        log.info("Total prepared statements so far : {}", (Object)totalPreparedStatementsCount);
    }
}

