/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.symmetric;

import edu.vt.middleware.crypt.symmetric.SymmetricAlgorithm;

public class Blowfish
extends SymmetricAlgorithm {
    public static final String ALGORITHM = "Blowfish";
    public static final int MIN_KEY_LENGTH = 32;
    public static final int MAX_KEY_LENGTH = 448;
    public static final int DEFAULT_KEY_LENGTH = 128;
    public static final int[] KEY_LENGTHS = new int[]{448, 384, 320, 256, 192, 128, 64};
    private static final int BITS_IN_BYTE = 8;

    public Blowfish() {
        this("CBC", "PKCS5Padding");
    }

    public Blowfish(String mode, String padding) {
        super(ALGORITHM, mode, padding);
    }

    public int getDefaultKeyLength() {
        return 128;
    }

    public int[] getAllowedKeyLengths() {
        return KEY_LENGTHS;
    }

    public int getMinKeyLength() {
        return 32;
    }

    public int getMaxKeyLength() {
        return 448;
    }

    public boolean isValidKeyLength(int bitLength) {
        if (bitLength < 32 || bitLength > 448) {
            return false;
        }
        return bitLength % 8 == 0;
    }
}

