/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.digest;

import edu.vt.middleware.crypt.AbstractCli;
import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.util.AbstractEncodingConverter;
import edu.vt.middleware.crypt.util.Base64Converter;
import edu.vt.middleware.crypt.util.HexConverter;
import java.io.InputStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;

public class DigestCli
extends AbstractCli {
    protected static final String OPT_ALG = "alg";
    protected static final String OPT_SALT = "salt";
    protected static final String OPT_ENCODING = "encoding";
    private static final String COMMAND_NAME = "digest";
    private HexConverter hexConv = new HexConverter();

    public static void main(String[] args) {
        new DigestCli().performAction(args);
    }

    protected void initOptions() {
        super.initOptions();
        Option algorithm = new Option(OPT_ALG, true, "digest algorithm name");
        algorithm.setArgName("name");
        algorithm.setOptionalArg(false);
        Option salt = new Option(OPT_SALT, true, "initialize digest with salt before hashing data");
        salt.setArgName("hex_salt");
        salt.setOptionalArg(false);
        Option infile = new Option("in", true, "file to digest; defaults to STDIN");
        infile.setArgName("filepath");
        infile.setOptionalArg(false);
        Option encoding = new Option(OPT_ENCODING, true, "output encoding format, either hex or base64");
        encoding.setArgName(OPT_ENCODING);
        encoding.setOptionalArg(false);
        this.options.addOption(algorithm);
        this.options.addOption(salt);
        this.options.addOption(infile);
        this.options.addOption(encoding);
    }

    protected void dispatch(CommandLine line) throws Exception {
        if (line.hasOption(OPT_ALG)) {
            this.digest(line);
        } else {
            this.printHelp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void digest(CommandLine line) throws Exception {
        DigestAlgorithm digest = DigestAlgorithm.newInstance(line.getOptionValue(OPT_ALG));
        if (line.hasOption(OPT_SALT)) {
            digest.setSalt(this.hexConv.toBytes(line.getOptionValue(OPT_SALT)));
        }
        byte[] hash = null;
        InputStream in = this.getInputStream(line);
        try {
            hash = digest.digest(in);
        }
        finally {
            this.closeStream(in);
        }
        if (line.hasOption(OPT_ENCODING)) {
            String encName = line.getOptionValue(OPT_ENCODING);
            AbstractEncodingConverter conv = null;
            if ("base64".equals(encName)) {
                conv = new Base64Converter();
            } else if ("hex".equals(encName)) {
                conv = this.hexConv;
            } else {
                throw new IllegalArgumentException("Unknown encoding.");
            }
            System.out.println(conv.fromBytes(hash));
        } else {
            System.out.print(hash);
        }
    }

    protected String getCommandName() {
        return COMMAND_NAME;
    }
}

