/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.asymmetric;

import edu.vt.middleware.crypt.AbstractEncryptionAlgorithm;
import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.CryptProvider;
import edu.vt.middleware.crypt.asymmetric.RSA;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class AsymmetricAlgorithm
extends AbstractEncryptionAlgorithm {
    public static final String MODE = "NONE";
    public static final String PADDING = "OAEPPadding";
    private static final int CHUNK_SIZE = 2048;
    private static final Map<String, Class<? extends AsymmetricAlgorithm>> NAME_CLASS_MAP = new HashMap<String, Class<? extends AsymmetricAlgorithm>>();

    protected AsymmetricAlgorithm(String cipherAlgorithm) {
        super(cipherAlgorithm, MODE, PADDING);
    }

    public static AsymmetricAlgorithm newInstance(String algorithm) {
        Class<? extends AsymmetricAlgorithm> clazz = NAME_CLASS_MAP.get(algorithm.toUpperCase());
        if (clazz != null) {
            try {
                return clazz.newInstance();
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        return new AsymmetricAlgorithm(algorithm);
    }

    public static KeyPair generateKeys(String algorithm, int bitLength, SecureRandom random) throws CryptException {
        if (random == null) {
            throw new CryptException("Source of random data cannot be null.");
        }
        return CryptProvider.getKeyPairGenerator(algorithm).generateKeyPair();
    }

    public KeyPair generateKeys() throws CryptException {
        return this.generateKeys(this.getDefaultKeyLength());
    }

    public KeyPair generateKeys(int bitLength) throws CryptException {
        if (this.randomProvider != null) {
            return AsymmetricAlgorithm.generateKeys(this.algorithm, bitLength, this.randomProvider);
        }
        return AsymmetricAlgorithm.generateKeys(this.algorithm, bitLength, new SecureRandom());
    }

    public int getDefaultKeyLength() {
        throw new UnsupportedOperationException("Default key length is not known.");
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return null;
    }

    protected int getChunkSize() {
        return 2048;
    }

    static {
        NAME_CLASS_MAP.put("RSA", RSA.class);
    }
}

