/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.model;

import com.webcohesion.enunciate.javac.decorations.DecoratedProcessingEnvironment;
import com.webcohesion.enunciate.javac.decorations.ElementDecorator;
import com.webcohesion.enunciate.javac.decorations.TypeMirrorDecorator;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedTypeElement;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedVariableElement;
import com.webcohesion.enunciate.javac.decorations.element.PropertyElement;
import com.webcohesion.enunciate.javac.decorations.type.DecoratedTypeMirror;
import com.webcohesion.enunciate.javac.decorations.type.TypeVariableContext;
import com.webcohesion.enunciate.modules.spring_web.model.ExplicitRequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.PathContext;
import com.webcohesion.enunciate.modules.spring_web.model.PathSegment;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceParameterConstraints;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceParameterType;
import com.webcohesion.enunciate.modules.spring_web.model.SimpleRequestParameter;
import com.webcohesion.enunciate.util.IgnoreUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.MatrixVariable;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;

public class RequestParameterFactory {
    public static final Set<String> KNOWN_SYSTEM_MANAGED_PARAMETER_TYPES = new TreeSet<String>(Arrays.asList("javax.servlet.ServletContext", "javax.servlet.ServletRequest", "javax.servlet.ServletResponse", "javax.servlet.http.HttpSession", "org.springframework.web.context.request.WebRequest", "java.util.Locale", "java.util.TimeZone", "java.time.ZoneId", "java.io.Writer", "java.io.OutputStream", "org.springframework.http.HttpMethod", "java.security.Principal", "org.springframework.ui.Model", "org.springframework.ui.ModelMap", "java.util.Map", "org.springframework.web.servlet.mvc.support.RedirectAttributes", "org.springframework.validation.Errors", "org.springframework.validation.BindingResult", "org.springframework.web.bind.support.SessionStatus", "org.springframework.web.util.UriComponentsBuilder"));

    public static List<RequestParameter> getRequestParameters(ExecutableElement mapping, VariableElement candidate, RequestMapping context) {
        ArrayList<RequestParameter> parameters = new ArrayList<RequestParameter>();
        if (!RequestParameterFactory.gatherAnnotatedRequestParameters(mapping, candidate, parameters, context) && !RequestParameterFactory.isSystemManagedParameter(candidate)) {
            RequestParameterFactory.gatherFormObjectParameters(candidate.asType(), parameters, context);
        }
        return parameters;
    }

    private static boolean isSystemManagedParameter(VariableElement candidate) {
        if (candidate.getAnnotation(ModelAttribute.class) != null) {
            return true;
        }
        TypeMirror parameterType = candidate.asType();
        while (parameterType instanceof DeclaredType) {
            Element element = ((DeclaredType)parameterType).asElement();
            if (element instanceof TypeElement) {
                String fqn = ((TypeElement)element).getQualifiedName().toString();
                if (KNOWN_SYSTEM_MANAGED_PARAMETER_TYPES.contains(fqn)) {
                    return true;
                }
                parameterType = ((TypeElement)element).getSuperclass();
                continue;
            }
            parameterType = null;
        }
        return false;
    }

    private static boolean gatherAnnotatedRequestParameters(ExecutableElement mapping, VariableElement candidate, List<RequestParameter> parameters, PathContext context) {
        List<? extends AnnotationMirror> annotations = candidate.getAnnotationMirrors();
        boolean success = false;
        Boolean isMapStringString = null;
        for (AnnotationMirror annotationMirror : annotations) {
            DecoratedTypeMirror decorated;
            TypeElement declaration = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (declaration == null) continue;
            String fqn = declaration.getQualifiedName().toString();
            if (IgnoreUtils.isIgnored((Element)declaration)) {
                parameters.clear();
                return true;
            }
            if (PathVariable.class.getName().equals(fqn)) {
                if (isMapStringString == null && (isMapStringString = Boolean.valueOf(RequestParameterFactory.isMapStringString(candidate.asType(), new TypeVariableContext(), context.getContext().getContext().getProcessingEnvironment()))).booleanValue() || isMapStringString.booleanValue()) {
                    for (PathSegment segment : context.getPathSegments()) {
                        if (segment.getVariable() == null) continue;
                        parameters.add(new ExplicitRequestParameter(mapping, null, segment.getVariable(), ResourceParameterType.PATH, false, segment.getRegex() == null ? new ResourceParameterConstraints.UnboundString() : new ResourceParameterConstraints.Regex(segment.getRegex()), context.getContext()));
                    }
                } else {
                    parameters.add(new SimpleRequestParameter((Element)candidate, context));
                }
                success = true;
            } else if (MatrixVariable.class.getName().equals(fqn) || RequestParam.class.getName().equals(fqn) || RequestHeader.class.getName().equals(fqn)) {
                if (isMapStringString == null && !(isMapStringString = Boolean.valueOf(RequestParameterFactory.isMapStringString(candidate.asType(), new TypeVariableContext(), context.getContext().getContext().getProcessingEnvironment()))).booleanValue() || !isMapStringString.booleanValue()) {
                    parameters.add(new SimpleRequestParameter((Element)candidate, context));
                }
                success = true;
            } else if (CookieValue.class.getName().equals(fqn) || RequestPart.class.getName().equals(fqn)) {
                parameters.add(new SimpleRequestParameter((Element)candidate, context));
                success = true;
            }
            if (!(decorated = (DecoratedTypeMirror)TypeMirrorDecorator.decorate((TypeMirror)annotationMirror.getAnnotationType(), (DecoratedProcessingEnvironment)context.getContext().getContext().getProcessingEnvironment())).isInstanceOf("org.springframework.data.domain.Pageable")) continue;
            parameters.add(new ExplicitRequestParameter(mapping, null, "page", ResourceParameterType.QUERY, false, new ResourceParameterConstraints.Primitive(TypeKind.INT), context.getContext()));
            parameters.add(new ExplicitRequestParameter(mapping, null, "size", ResourceParameterType.QUERY, false, new ResourceParameterConstraints.Primitive(TypeKind.INT), context.getContext()));
            return true;
        }
        return success;
    }

    private static boolean isMapStringString(TypeMirror candidate, TypeVariableContext variableContext, DecoratedProcessingEnvironment env) {
        Element el;
        Element element = candidate instanceof DeclaredType ? ((DeclaredType)candidate).asElement() : (el = candidate instanceof TypeVariable ? ((TypeVariable)candidate).asElement() : null);
        if (el instanceof TypeElement) {
            TypeElement element2 = (TypeElement)el;
            String fqn = element2.getQualifiedName().toString();
            if (Object.class.getName().equals(fqn)) {
                return false;
            }
            if ("org.springframework.util.MultiValueMap".equals(fqn) || Map.class.getName().equalsIgnoreCase(fqn)) {
                List<? extends TypeMirror> typeArgs;
                TypeMirror resolvedType = variableContext.resolveTypeVariables(candidate, (ProcessingEnvironment)env);
                if (resolvedType instanceof DeclaredType && (typeArgs = ((DeclaredType)resolvedType).getTypeArguments()).size() == 2 && ((DecoratedTypeMirror)typeArgs.get(0)).isInstanceOf(String.class) && ((DecoratedTypeMirror)typeArgs.get(1)).isInstanceOf(String.class)) {
                    return true;
                }
            } else {
                TypeMirror superclass = element2.getSuperclass();
                if (superclass != null && superclass.getKind() != TypeKind.NONE) {
                    return RequestParameterFactory.isMapStringString(superclass, variableContext.push(element2.getTypeParameters(), candidate instanceof DeclaredType ? ((DeclaredType)candidate).getTypeArguments() : new ArrayList()), env);
                }
            }
        }
        return false;
    }

    private static void gatherFormObjectParameters(TypeMirror type, ArrayList<RequestParameter> params, RequestMapping context) {
        if (type instanceof DeclaredType) {
            Set<String> methods = context.getHttpMethods();
            ResourceParameterType defaultType = methods.contains("POST") ? ResourceParameterType.FORM : ResourceParameterType.QUERY;
            DecoratedTypeElement typeDeclaration = (DecoratedTypeElement)ElementDecorator.decorate((Element)((DeclaredType)type).asElement(), (DecoratedProcessingEnvironment)context.getContext().getContext().getProcessingEnvironment());
            for (VariableElement field : ElementFilter.fieldsIn(typeDeclaration.getEnclosedElements())) {
                DecoratedVariableElement decorated = (DecoratedVariableElement)field;
                if (decorated.isFinal() || decorated.isTransient() || !decorated.isPublic()) continue;
                params.add(new SimpleRequestParameter((Element)decorated, context, defaultType));
            }
            for (PropertyElement property : typeDeclaration.getProperties()) {
                if (property.getSetter() == null) continue;
                params.add(new SimpleRequestParameter((Element)property, context, defaultType));
            }
            if (typeDeclaration.getKind() == ElementKind.CLASS) {
                RequestParameterFactory.gatherFormObjectParameters(typeDeclaration.getSuperclass(), params, context);
            }
        }
    }
}

