/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.modules.spring_web.api.impl;

import com.webcohesion.enunciate.api.ApiRegistrationContext;
import com.webcohesion.enunciate.api.Styles;
import com.webcohesion.enunciate.api.resources.Entity;
import com.webcohesion.enunciate.api.resources.Example;
import com.webcohesion.enunciate.api.resources.Method;
import com.webcohesion.enunciate.api.resources.Parameter;
import com.webcohesion.enunciate.api.resources.Resource;
import com.webcohesion.enunciate.api.resources.ResourceGroup;
import com.webcohesion.enunciate.api.resources.StatusCode;
import com.webcohesion.enunciate.facets.Facet;
import com.webcohesion.enunciate.javac.decorations.element.DecoratedElement;
import com.webcohesion.enunciate.javac.decorations.element.ElementUtils;
import com.webcohesion.enunciate.javac.javadoc.JavaDoc;
import com.webcohesion.enunciate.modules.spring_web.api.impl.MethodExampleImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ParameterImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.RequestEntityImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResourceImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResponseEntityImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.ResponseHeaderParameterImpl;
import com.webcohesion.enunciate.modules.spring_web.api.impl.StatusCodeImpl;
import com.webcohesion.enunciate.modules.spring_web.model.RequestMapping;
import com.webcohesion.enunciate.modules.spring_web.model.RequestParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceEntityParameter;
import com.webcohesion.enunciate.modules.spring_web.model.ResourceRepresentationMetadata;
import com.webcohesion.enunciate.modules.spring_web.model.ResponseCode;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class MethodImpl
implements Method {
    private final String httpMethod;
    private final RequestMapping requestMapping;
    private final ResourceGroup group;
    private final MethodExampleImpl example;
    private final ApiRegistrationContext registrationContext;

    public MethodImpl(String httpMethod, RequestMapping requestMapping, ResourceGroup group, ApiRegistrationContext registrationContext) {
        this.httpMethod = httpMethod;
        this.requestMapping = requestMapping;
        this.group = group;
        this.registrationContext = registrationContext;
        this.example = this.requestMapping.getContext().isDisableExamples() ? null : new MethodExampleImpl(this.httpMethod, this.requestMapping, this.registrationContext);
    }

    public Resource getResource() {
        return new ResourceImpl(this.requestMapping, this.group, this.registrationContext);
    }

    public String getLabel() {
        return this.requestMapping.getLabel() == null ? this.httpMethod : this.requestMapping.getLabel();
    }

    public String getDeveloperLabel() {
        return this.requestMapping.getSimpleName().toString();
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public String getSlug() {
        return this.group.getSlug() + "_" + this.requestMapping.getSimpleName() + "_" + this.httpMethod;
    }

    public String getDescription() {
        return this.requestMapping.getJavaDoc(this.registrationContext.getTagHandler()).toString();
    }

    public String getDeprecated() {
        String deprecated = ElementUtils.findDeprecationMessage((DecoratedElement)this.requestMapping);
        if (deprecated == null) {
            deprecated = ElementUtils.findDeprecationMessage((DecoratedElement)this.requestMapping.getParent());
        }
        return deprecated;
    }

    public String getSince() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.requestMapping.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"since");
        return tags == null ? null : tags.toString();
    }

    public List<String> getSeeAlso() {
        return (List)this.requestMapping.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"see");
    }

    public String getVersion() {
        JavaDoc.JavaDocTagList tags = (JavaDoc.JavaDocTagList)this.requestMapping.getJavaDoc(this.registrationContext.getTagHandler()).get((Object)"version");
        return tags == null ? null : tags.toString();
    }

    public boolean isIncludeDefaultParameterValues() {
        for (RequestParameter parameter : this.requestMapping.getRequestParameters()) {
            if (parameter.getDefaultValue() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isHasParameterConstraints() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.getConstraints() == null) continue;
            return true;
        }
        return false;
    }

    public boolean isHasParameterMultiplicity() {
        for (RequestParameter parameter : this.requestMapping.getRequestParameters()) {
            if (!parameter.isMultivalued()) continue;
            return true;
        }
        return false;
    }

    public List<? extends Parameter> getParameters() {
        Set<RequestParameter> resourceParams = this.requestMapping.getRequestParameters();
        ArrayList<ParameterImpl> parameters = new ArrayList<ParameterImpl>(resourceParams.size());
        for (RequestParameter param : resourceParams) {
            parameters.add(new ParameterImpl(param));
        }
        return parameters;
    }

    public Entity getRequestEntity() {
        ResourceEntityParameter entityParameter = this.requestMapping.getEntityParameter();
        return entityParameter == null ? null : new RequestEntityImpl(this.requestMapping, entityParameter, this.registrationContext);
    }

    public List<? extends StatusCode> getResponseCodes() {
        ArrayList<StatusCodeImpl> statusCodes = new ArrayList<StatusCodeImpl>();
        for (ResponseCode responseCode : this.requestMapping.getStatusCodes()) {
            statusCodes.add(new StatusCodeImpl(responseCode, this.registrationContext));
        }
        return statusCodes;
    }

    public Entity getResponseEntity() {
        ResourceRepresentationMetadata responseMetadata = this.requestMapping.getRepresentationMetadata();
        return responseMetadata == null ? null : new ResponseEntityImpl(this.requestMapping, responseMetadata, this.registrationContext);
    }

    public List<? extends StatusCode> getWarnings() {
        ArrayList<StatusCodeImpl> statusCodes = new ArrayList<StatusCodeImpl>();
        for (ResponseCode responseCode : this.requestMapping.getWarnings()) {
            statusCodes.add(new StatusCodeImpl(responseCode, this.registrationContext));
        }
        return statusCodes;
    }

    public List<? extends Parameter> getResponseHeaders() {
        Map<String, String> responseHeaders = this.requestMapping.getResponseHeaders();
        ArrayList<ResponseHeaderParameterImpl> headerValues = new ArrayList<ResponseHeaderParameterImpl>();
        for (Map.Entry<String, String> responseHeader : responseHeaders.entrySet()) {
            headerValues.add(new ResponseHeaderParameterImpl(responseHeader.getKey(), responseHeader.getValue(), Collections.<String>emptySet()));
        }
        return headerValues;
    }

    public Set<String> getSecurityRoles() {
        return this.requestMapping.getSecurityRoles();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return (A)this.requestMapping.getAnnotation(annotationType);
    }

    public Map<String, AnnotationMirror> getAnnotations() {
        return this.requestMapping.getAnnotations();
    }

    public Set<Facet> getFacets() {
        return this.requestMapping.getFacets();
    }

    public JavaDoc getJavaDoc() {
        return this.requestMapping.getJavaDoc(this.registrationContext.getTagHandler());
    }

    public Set<String> getStyles() {
        return Styles.gatherStyles((Element)((Object)this.requestMapping), (Map)this.requestMapping.getContext().getContext().getConfiguration().getAnnotationStyles());
    }

    public Example getExample() {
        return this.example;
    }

    public RequestMapping getRequestMapping() {
        return this.requestMapping;
    }
}

