/*
 * Decompiled with CFR 0.152.
 */
package com.webcohesion.enunciate.mojo;

import com.webcohesion.enunciate.Enunciate;
import com.webcohesion.enunciate.artifacts.Artifact;
import com.webcohesion.enunciate.artifacts.ArtifactType;
import com.webcohesion.enunciate.artifacts.ClientLibraryArtifact;
import com.webcohesion.enunciate.artifacts.FileArtifact;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.install.InstallFileMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="install-artifact", defaultPhase=LifecyclePhase.INSTALL, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class InstallArtifactBaseMojo
extends InstallFileMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter
    protected String enunciateArtifactId;
    @Parameter
    protected File file;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.enunciateArtifactId == null) {
            throw new MojoExecutionException("An id of the enunciate artifact to be installed must be configured.");
        }
        Enunciate enunciate = (Enunciate)this.getPluginContext().get("com.webcohesion.enunciate.mojo.ConfigMojo#ENUNCIATE_PROPERTY");
        if (enunciate == null) {
            throw new MojoExecutionException("No enunciate mechanism found in the project!");
        }
        Artifact artifact = enunciate.findArtifact(this.enunciateArtifactId);
        if (artifact == null) {
            throw new MojoExecutionException("Unknown Enunciate artifact: " + this.enunciateArtifactId + ".");
        }
        File mainArtifact = null;
        File sources = null;
        File javadocs = null;
        if (artifact instanceof ClientLibraryArtifact) {
            for (Artifact childArtifact : ((ClientLibraryArtifact)artifact).getArtifacts()) {
                ArtifactType artifactType;
                if (!(childArtifact instanceof FileArtifact) || (artifactType = ((FileArtifact)childArtifact).getArtifactType()) == null) continue;
                switch (artifactType) {
                    case binaries: {
                        mainArtifact = ((FileArtifact)childArtifact).getFile();
                        break;
                    }
                    case sources: {
                        sources = ((FileArtifact)childArtifact).getFile();
                        break;
                    }
                    case javadocs: {
                        javadocs = ((FileArtifact)childArtifact).getFile();
                    }
                }
            }
            if (mainArtifact == null) {
                throw new MojoExecutionException("Unable to install artifact '" + this.enunciateArtifactId + "': no binaries available. This is likely because the '" + artifact.getModule() + "' module didn't compile the binaries.");
            }
        } else if (artifact instanceof FileArtifact) {
            mainArtifact = ((FileArtifact)artifact).getFile();
        } else {
            try {
                mainArtifact = enunciate.createTempFile(this.enunciateArtifactId, "artifact");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create a temp file.", (Exception)e);
            }
        }
        if (this.packaging == null) {
            int dotIndex;
            String artifactName;
            String string = artifactName = mainArtifact != null ? mainArtifact.getName() : null;
            if (artifactName != null && (dotIndex = artifactName.indexOf(46)) > 0 && dotIndex + 1 < artifactName.length()) {
                this.packaging = artifactName.substring(dotIndex + 1);
            }
        }
        if (this.packaging == null) {
            throw new MojoExecutionException("Unable to determine the packaging of enunciate artifact " + this.enunciateArtifactId + ". Please specify it in the configuration.");
        }
        if (this.groupId == null) {
            this.groupId = this.project.getGroupId();
        }
        if (this.artifactId == null) {
            this.artifactId = this.project.getArtifactId() + "-client";
        }
        if (this.version == null) {
            this.version = this.project.getVersion();
        }
        this.setPrivateField("file", mainArtifact);
        this.setPrivateField("sources", sources);
        this.setPrivateField("javadoc", javadocs);
        super.execute();
    }

    private void setPrivateField(String fieldName, Object value) {
        Field field = this.findField(InstallFileMojo.class, fieldName);
        if (field == null) {
            throw new IllegalStateException("No such field: " + fieldName);
        }
        field.setAccessible(true);
        try {
            field.set((Object)this, value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private Field findField(Class clazz, String fieldName) {
        if (Object.class.equals((Object)clazz)) {
            return null;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        return this.findField(clazz.getSuperclass(), fieldName);
    }
}

