/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.common.util;

import com.google.common.base.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RetryHelper {
    private RetryHelper() {
    }

    public static <R> R retry(@Nonnull ExceptionHandler<R, RuntimeException> handler, Callable<R> job) {
        return RetryHelper.retryOrThrow(handler, job);
    }

    public static <R, T extends Exception> R retryOrThrow(@Nonnull ExceptionHandler<R, T> handler, Callable<R> job) throws T {
        RetryCallback retryCallback = null;
        int attempts = 0;
        while (true) {
            try {
                return job.call();
            }
            catch (Exception ex) {
                ++attempts;
                if (retryCallback == null) {
                    retryCallback = new RetryCallback();
                }
                handler.handleException(retryCallback, ex, attempts);
                switch (retryCallback.action) {
                    case RETURN: {
                        return (R)retryCallback.result;
                    }
                }
                continue;
            }
            break;
        }
    }

    public static <R, T extends Exception> ExceptionHandler<R, T> throwHandler() {
        return ThrowExceptionHandler.getInstance();
    }

    public static <R, T extends Exception> ExceptionHandler<R, T> alwaysRetryHandler() {
        return AlwaysRetryExceptionHandler.getInstance();
    }

    public static <R, T extends Exception> ExceptionHandler<R, T> defaultValueHandler(R defaultResult) {
        return new DefaultValueExceptionHandler(defaultResult);
    }

    public static <R, T extends Exception> ExceptionHandler<R, T> retryUntilHandler(int maxAttempts, R defaultValue) {
        ExceptionHandler<R, T> beforeHandler = RetryHelper.alwaysRetryHandler();
        ExceptionHandler<R, T> afterHandler = RetryHelper.defaultValueHandler(defaultValue);
        return new UntilAttemptsExceptionHandler<R, T>(maxAttempts, beforeHandler, afterHandler);
    }

    public static <R, T extends Exception> ExceptionHandler<R, T> retryUntilHandler(int maxAttempts, ExceptionHandler<R, T> afterHandler) {
        ExceptionHandler<R, T> beforeHandler = RetryHelper.alwaysRetryHandler();
        return new UntilAttemptsExceptionHandler<R, T>(maxAttempts, beforeHandler, afterHandler);
    }

    public static <R, T extends Exception> ExceptionHandler<R, T> waitExceptionHandler(long millis) {
        return new WaitExceptionHandler(millis);
    }

    public static <R, T extends Exception> StorerExceptionHandler<R, T> storerExceptionHandler(Class<T> excetionClass, ExceptionHandler<R, T> delegate) {
        return new StorerExceptionHandler<R, T>(delegate, excetionClass);
    }

    public static class StorerExceptionHandler<R, T extends Exception>
    extends DelegateExceptionHandler<R, T> {
        private final Class<T> exClass;
        private Optional<T> thrown;

        public StorerExceptionHandler(ExceptionHandler<R, T> delegate, Class<T> exClass) {
            super(delegate);
            this.exClass = exClass;
            this.thrown = Optional.absent();
        }

        @Override
        public void handleException(RetryCallback<R> callback, Exception t, int attempts) throws T {
            if (this.exClass.isInstance(t)) {
                this.thrown = Optional.of((Object)t);
            } else {
                super.handleException(callback, t, attempts);
            }
        }

        public Optional<T> getThrown() {
            return this.thrown;
        }
    }

    public static class WaitExceptionHandler<Result, T extends Exception>
    implements ExceptionHandler<Result, T> {
        private final long millis;

        public WaitExceptionHandler(long millis) {
            this.millis = millis;
        }

        @Override
        public void handleException(RetryCallback<Result> callback, Exception t, int attempts) throws T {
            try {
                Thread.sleep(this.millis);
            }
            catch (InterruptedException ex) {
                Thread.interrupted();
            }
            callback.doRetry();
        }
    }

    public static class UntilAttemptsExceptionHandler<Result, T extends Exception>
    implements ExceptionHandler<Result, T> {
        private final int maxAttempts;
        private final ExceptionHandler<Result, T> beforeLimitDelegate;
        private final ExceptionHandler<Result, T> afterLimitDelegate;

        public UntilAttemptsExceptionHandler(int maxAttempts, ExceptionHandler<Result, T> beforeLimitDelegate, ExceptionHandler<Result, T> afterLimitDelegate) {
            this.maxAttempts = maxAttempts;
            this.beforeLimitDelegate = beforeLimitDelegate;
            this.afterLimitDelegate = afterLimitDelegate;
        }

        @Override
        public void handleException(RetryCallback<Result> callback, Exception t, int attempts) throws T {
            if (attempts < this.maxAttempts) {
                this.beforeLimitDelegate.handleException(callback, t, attempts);
            } else {
                this.afterLimitDelegate.handleException(callback, t, attempts);
            }
        }
    }

    public static class DelegateExceptionHandler<Result, T extends Exception>
    implements ExceptionHandler<Result, T> {
        private final ExceptionHandler<Result, T> delegate;

        public DelegateExceptionHandler(ExceptionHandler<Result, T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void handleException(RetryCallback<Result> callback, Exception t, int attempts) throws T {
            this.delegate.handleException(callback, t, attempts);
        }
    }

    public static class DefaultValueExceptionHandler<R, T extends Exception>
    implements ExceptionHandler<R, T> {
        private final R defaultValue;

        public DefaultValueExceptionHandler(R defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public void handleException(RetryCallback<R> callback, Exception t, int attempts) throws T {
            callback.doReturn(this.defaultValue);
        }
    }

    public static class AlwaysRetryExceptionHandler<R, T extends Exception>
    implements ExceptionHandler<R, T> {
        private static final AlwaysRetryExceptionHandler INSTANCE = new AlwaysRetryExceptionHandler();

        private static <R2, T2 extends Exception> AlwaysRetryExceptionHandler<R2, T2> getInstance() {
            return INSTANCE;
        }

        @Override
        public void handleException(RetryCallback<R> callback, Exception t, int attempts) throws T {
            callback.doRetry();
        }
    }

    public static class ThrowExceptionHandler<R, T extends Exception>
    implements ExceptionHandler<R, T> {
        private static final ThrowExceptionHandler INSTANCE = new ThrowExceptionHandler();

        private static <R2, T2 extends Exception> ThrowExceptionHandler<R2, T2> getInstance() {
            return INSTANCE;
        }

        @Override
        public void handleException(RetryCallback<R> callback, Exception t, int attempts) throws T {
            try {
                throw t;
            }
            catch (Exception throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    public static interface ExceptionHandler<Result, T extends Exception> {
        public void handleException(RetryCallback<Result> var1, Exception var2, int var3) throws T;
    }

    private static enum RetryAction {
        RETRY,
        RETURN;

    }

    public static class RetryCallback<Result> {
        @Nonnull
        RetryAction action = RetryAction.RETRY;
        @Nullable
        Result result;

        public void doRetry() {
            this.action = RetryAction.RETRY;
        }

        public void doReturn(Result result) {
            this.result = result;
            this.action = RetryAction.RETURN;
        }
    }
}

