/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.common.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import java.util.Collection;
import javax.annotation.Nonnull;

public class OctetUtils {
    private static final char[] BYTE_OCTET_VALUES = new char[768];

    public static String bytes2Octet(@Nonnull byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes");
        int length = bytes.length;
        char[] chars = new char[length * 4];
        int charPos = 0;
        for (int i = 0; i < length; ++i) {
            int index = (bytes[i] & 0xFF) * 3;
            chars[charPos++] = 92;
            chars[charPos++] = BYTE_OCTET_VALUES[index++];
            chars[charPos++] = BYTE_OCTET_VALUES[index++];
            chars[charPos++] = BYTE_OCTET_VALUES[index];
        }
        return new String(chars);
    }

    public static String bytes2Octet(@Nonnull Collection<Byte> bytes) {
        Preconditions.checkNotNull(bytes, (Object)"bytes");
        int length = bytes.size();
        char[] chars = new char[length * 3];
        int charPos = 0;
        for (Byte b : bytes) {
            int index = (b & 0xFF) * 3;
            chars[charPos++] = 92;
            chars[charPos++] = BYTE_OCTET_VALUES[index++];
            chars[charPos++] = BYTE_OCTET_VALUES[index++];
            chars[charPos++] = BYTE_OCTET_VALUES[index];
        }
        return new String(chars);
    }

    public static void bytes2Octet(@Nonnull byte[] bytes, StringBuilder output) {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes");
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            int index = (b & 0xFF) * 3;
            output.append('\\');
            output.append(BYTE_OCTET_VALUES[index++]);
            output.append(BYTE_OCTET_VALUES[index++]);
            output.append(BYTE_OCTET_VALUES[index]);
        }
    }

    public static byte[] octet2Bytes(@Nonnull String value) {
        Preconditions.checkNotNull((Object)value);
        int r = 0;
        byte[] result = new byte[value.length() / 5];
        for (int i = 0; i < value.length(); i += 5) {
            if (value.charAt(i) == '\\') {
                String substring = value.substring(i + 2, i + 5);
                assert (substring.length() == 3);
                result[r] = UnsignedBytes.parseUnsignedByte((String)substring, (int)8);
            } else {
                assert (value.charAt(i) < '\u0100');
                result[r] = (byte)value.charAt(i);
            }
            ++r;
        }
        return result;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int high = i >>> 6;
            int middle = i >>> 3 & 7;
            int low = i & 7;
            OctetUtils.BYTE_OCTET_VALUES[i * 3] = (char)(48 + high);
            OctetUtils.BYTE_OCTET_VALUES[i * 3 + 1] = (char)(48 + middle);
            OctetUtils.BYTE_OCTET_VALUES[i * 3 + 2] = (char)(48 + low);
        }
    }
}

