/*
 * Decompiled with CFR 0.152.
 */
package com.torodb.common.util;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import java.util.Collection;
import javax.annotation.Nonnull;

public class HexUtils {
    private static final char[] BYTE_HEX_VALUES = new char[512];

    public static String bytes2Hex(@Nonnull byte[] bytes) {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes");
        int length = bytes.length;
        char[] chars = new char[length << 1];
        int charPos = 0;
        for (int i = 0; i < length; ++i) {
            int index = (bytes[i] & 0xFF) << 1;
            chars[charPos++] = BYTE_HEX_VALUES[index++];
            chars[charPos++] = BYTE_HEX_VALUES[index];
        }
        return new String(chars);
    }

    public static String bytes2Hex(@Nonnull Collection<Byte> bytes) {
        Preconditions.checkNotNull(bytes, (Object)"bytes");
        int length = bytes.size();
        char[] chars = new char[length << 1];
        int charPos = 0;
        for (Byte b : bytes) {
            int index = (b & 0xFF) << 1;
            chars[charPos++] = BYTE_HEX_VALUES[index++];
            chars[charPos++] = BYTE_HEX_VALUES[index];
        }
        return new String(chars);
    }

    public static void bytes2Hex(@Nonnull byte[] bytes, StringBuilder output) {
        Preconditions.checkNotNull((Object)bytes, (Object)"bytes");
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            int index = (b & 0xFF) << 1;
            output.append(BYTE_HEX_VALUES[index++]);
            output.append(BYTE_HEX_VALUES[index]);
        }
    }

    public static byte[] hex2Bytes(@Nonnull String value) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkArgument((value.length() % 2 == 0 ? 1 : 0) != 0, (Object)"A string with a even lenght was expected");
        int r = 0;
        byte[] result = new byte[value.length() / 2];
        for (int i = 0; i < value.length(); i += 2) {
            assert (r == i / 2);
            String substring = value.substring(i, i + 2);
            assert (substring.length() == 2);
            result[r] = UnsignedBytes.parseUnsignedByte((String)substring, (int)16);
            ++r;
        }
        return result;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int high = i >>> 4;
            int low = i & 0xF;
            HexUtils.BYTE_HEX_VALUES[i << 1] = high < 10 ? (char)(48 + high) : (char)(65 + high - 10);
            HexUtils.BYTE_HEX_VALUES[(i << 1) + 1] = low < 10 ? (char)(48 + low) : (char)(65 + low - 10);
        }
    }
}

