/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.claims;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.langtag.LangTag;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.oauth2.sdk.token.TypelessAccessToken;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.Address;
import com.nimbusds.openid.connect.sdk.claims.AggregatedClaims;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.DistributedClaims;
import com.nimbusds.openid.connect.sdk.claims.ExternalClaimsUtils;
import com.nimbusds.openid.connect.sdk.claims.Gender;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import net.minidev.json.JSONObject;

public class UserInfo
extends ClaimsSet {
    public static final String SUB_CLAIM_NAME = "sub";
    public static final String ISS_CLAIM_NAME = "iss";
    public static final String AUD_CLAIM_NAME = "aud";
    public static final String NAME_CLAIM_NAME = "name";
    public static final String GIVEN_NAME_CLAIM_NAME = "given_name";
    public static final String FAMILY_NAME_CLAIM_NAME = "family_name";
    public static final String MIDDLE_NAME_CLAIM_NAME = "middle_name";
    public static final String NICKNAME_CLAIM_NAME = "nickname";
    public static final String PREFERRED_USERNAME_CLAIM_NAME = "preferred_username";
    public static final String PROFILE_CLAIM_NAME = "profile";
    public static final String PICTURE_CLAIM_NAME = "picture";
    public static final String WEBSITE_CLAIM_NAME = "website";
    public static final String EMAIL_CLAIM_NAME = "email";
    public static final String EMAIL_VERIFIED_CLAIM_NAME = "email_verified";
    public static final String GENDER_CLAIM_NAME = "gender";
    public static final String BIRTHDATE_CLAIM_NAME = "birthdate";
    public static final String ZONEINFO_CLAIM_NAME = "zoneinfo";
    public static final String LOCALE_CLAIM_NAME = "locale";
    public static final String PHONE_NUMBER_CLAIM_NAME = "phone_number";
    public static final String PHONE_NUMBER_VERIFIED_CLAIM_NAME = "phone_number_verified";
    public static final String ADDRESS_CLAIM_NAME = "address";
    public static final String UPDATED_AT_CLAIM_NAME = "updated_at";
    private static final Set<String> stdClaimNames = new LinkedHashSet<String>();

    static {
        stdClaimNames.add(SUB_CLAIM_NAME);
        stdClaimNames.add(ISS_CLAIM_NAME);
        stdClaimNames.add(AUD_CLAIM_NAME);
        stdClaimNames.add(NAME_CLAIM_NAME);
        stdClaimNames.add(GIVEN_NAME_CLAIM_NAME);
        stdClaimNames.add(FAMILY_NAME_CLAIM_NAME);
        stdClaimNames.add(MIDDLE_NAME_CLAIM_NAME);
        stdClaimNames.add(NICKNAME_CLAIM_NAME);
        stdClaimNames.add(PREFERRED_USERNAME_CLAIM_NAME);
        stdClaimNames.add(PROFILE_CLAIM_NAME);
        stdClaimNames.add(PICTURE_CLAIM_NAME);
        stdClaimNames.add(WEBSITE_CLAIM_NAME);
        stdClaimNames.add(EMAIL_CLAIM_NAME);
        stdClaimNames.add(EMAIL_VERIFIED_CLAIM_NAME);
        stdClaimNames.add(GENDER_CLAIM_NAME);
        stdClaimNames.add(BIRTHDATE_CLAIM_NAME);
        stdClaimNames.add(ZONEINFO_CLAIM_NAME);
        stdClaimNames.add(LOCALE_CLAIM_NAME);
        stdClaimNames.add(PHONE_NUMBER_CLAIM_NAME);
        stdClaimNames.add(PHONE_NUMBER_VERIFIED_CLAIM_NAME);
        stdClaimNames.add(ADDRESS_CLAIM_NAME);
        stdClaimNames.add(UPDATED_AT_CLAIM_NAME);
    }

    public static Set<String> getStandardClaimNames() {
        return Collections.unmodifiableSet(stdClaimNames);
    }

    public UserInfo(Subject sub) {
        this.setClaim(SUB_CLAIM_NAME, sub.getValue());
    }

    public UserInfo(JSONObject jsonObject) {
        super(jsonObject);
        if (this.getStringClaim(SUB_CLAIM_NAME) == null) {
            throw new IllegalArgumentException("Missing or invalid \"sub\" claim");
        }
    }

    public UserInfo(JWTClaimsSet jwtClaimsSet) {
        this(jwtClaimsSet.toJSONObject());
    }

    public void putAll(UserInfo other) {
        Subject otherSubject = other.getSubject();
        if (otherSubject == null) {
            throw new IllegalArgumentException("The subject of the other UserInfo is missing");
        }
        if (!otherSubject.equals(this.getSubject())) {
            throw new IllegalArgumentException("The subject of the other UserInfo must be identical");
        }
        Set<AggregatedClaims> savedAggregatedClaims = this.getAggregatedClaims();
        Set<DistributedClaims> savedDistributedClaims = this.getDistributedClaims();
        Set<AggregatedClaims> otherAggregatedClaims = other.getAggregatedClaims();
        Set<DistributedClaims> otherDistributedClaims = other.getDistributedClaims();
        HashSet<String> externalSourceIDs = new HashSet<String>();
        if (savedAggregatedClaims != null) {
            for (AggregatedClaims ac : savedAggregatedClaims) {
                externalSourceIDs.add(ac.getSourceID());
            }
        }
        if (savedDistributedClaims != null) {
            for (DistributedClaims dc : savedDistributedClaims) {
                externalSourceIDs.add(dc.getSourceID());
            }
        }
        if (otherAggregatedClaims != null) {
            for (AggregatedClaims ac : otherAggregatedClaims) {
                if (!externalSourceIDs.contains(ac.getSourceID())) continue;
                throw new IllegalArgumentException("Aggregated claims source ID conflict: " + ac.getSourceID());
            }
        }
        if (otherDistributedClaims != null) {
            for (DistributedClaims dc : otherDistributedClaims) {
                if (!externalSourceIDs.contains(dc.getSourceID())) continue;
                throw new IllegalArgumentException("Distributed claims source ID conflict: " + dc.getSourceID());
            }
        }
        this.putAll((ClaimsSet)other);
        if (savedAggregatedClaims != null) {
            for (AggregatedClaims ac : savedAggregatedClaims) {
                this.addAggregatedClaims(ac);
            }
        }
        if (savedDistributedClaims != null) {
            for (DistributedClaims dc : savedDistributedClaims) {
                this.addDistributedClaims(dc);
            }
        }
    }

    public Subject getSubject() {
        return new Subject(this.getStringClaim(SUB_CLAIM_NAME));
    }

    public Issuer getIssuer() {
        String iss = this.getStringClaim(ISS_CLAIM_NAME);
        return iss != null ? new Issuer(iss) : null;
    }

    public void setIssuer(Issuer iss) {
        if (iss != null) {
            this.setClaim(ISS_CLAIM_NAME, iss.getValue());
        } else {
            this.setClaim(ISS_CLAIM_NAME, null);
        }
    }

    public List<Audience> getAudience() {
        List<String> list = this.getStringListClaim(AUD_CLAIM_NAME);
        return list != null && !list.isEmpty() ? Audience.create(list) : null;
    }

    public void setAudience(Audience aud) {
        if (aud != null) {
            this.setAudience(aud.toSingleAudienceList());
        } else {
            this.setClaim(AUD_CLAIM_NAME, null);
        }
    }

    public void setAudience(List<Audience> audList) {
        if (audList != null) {
            this.setClaim(AUD_CLAIM_NAME, Audience.toStringList(audList));
        } else {
            this.setClaim(AUD_CLAIM_NAME, null);
        }
    }

    public String getName() {
        return this.getStringClaim(NAME_CLAIM_NAME);
    }

    public String getName(LangTag langTag) {
        return this.getStringClaim(NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getNameEntries() {
        return this.getLangTaggedClaim(NAME_CLAIM_NAME, String.class);
    }

    public void setName(String name) {
        this.setClaim(NAME_CLAIM_NAME, name);
    }

    public void setName(String name, LangTag langTag) {
        this.setClaim(NAME_CLAIM_NAME, name, langTag);
    }

    public String getGivenName() {
        return this.getStringClaim(GIVEN_NAME_CLAIM_NAME);
    }

    public String getGivenName(LangTag langTag) {
        return this.getStringClaim(GIVEN_NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getGivenNameEntries() {
        return this.getLangTaggedClaim(GIVEN_NAME_CLAIM_NAME, String.class);
    }

    public void setGivenName(String givenName) {
        this.setClaim(GIVEN_NAME_CLAIM_NAME, givenName);
    }

    public void setGivenName(String givenName, LangTag langTag) {
        this.setClaim(GIVEN_NAME_CLAIM_NAME, givenName, langTag);
    }

    public String getFamilyName() {
        return this.getStringClaim(FAMILY_NAME_CLAIM_NAME);
    }

    public String getFamilyName(LangTag langTag) {
        return this.getStringClaim(FAMILY_NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getFamilyNameEntries() {
        return this.getLangTaggedClaim(FAMILY_NAME_CLAIM_NAME, String.class);
    }

    public void setFamilyName(String familyName) {
        this.setClaim(FAMILY_NAME_CLAIM_NAME, familyName);
    }

    public void setFamilyName(String familyName, LangTag langTag) {
        this.setClaim(FAMILY_NAME_CLAIM_NAME, familyName, langTag);
    }

    public String getMiddleName() {
        return this.getStringClaim(MIDDLE_NAME_CLAIM_NAME);
    }

    public String getMiddleName(LangTag langTag) {
        return this.getStringClaim(MIDDLE_NAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getMiddleNameEntries() {
        return this.getLangTaggedClaim(MIDDLE_NAME_CLAIM_NAME, String.class);
    }

    public void setMiddleName(String middleName) {
        this.setClaim(MIDDLE_NAME_CLAIM_NAME, middleName);
    }

    public void setMiddleName(String middleName, LangTag langTag) {
        this.setClaim(MIDDLE_NAME_CLAIM_NAME, middleName, langTag);
    }

    public String getNickname() {
        return this.getStringClaim(NICKNAME_CLAIM_NAME);
    }

    public String getNickname(LangTag langTag) {
        return this.getStringClaim(NICKNAME_CLAIM_NAME, langTag);
    }

    public Map<LangTag, String> getNicknameEntries() {
        return this.getLangTaggedClaim(NICKNAME_CLAIM_NAME, String.class);
    }

    public void setNickname(String nickname) {
        this.setClaim(NICKNAME_CLAIM_NAME, nickname);
    }

    public void setNickname(String nickname, LangTag langTag) {
        this.setClaim(NICKNAME_CLAIM_NAME, nickname, langTag);
    }

    public String getPreferredUsername() {
        return this.getStringClaim(PREFERRED_USERNAME_CLAIM_NAME);
    }

    public void setPreferredUsername(String preferredUsername) {
        this.setClaim(PREFERRED_USERNAME_CLAIM_NAME, preferredUsername);
    }

    public URI getProfile() {
        return this.getURIClaim(PROFILE_CLAIM_NAME);
    }

    public void setProfile(URI profile) {
        this.setURIClaim(PROFILE_CLAIM_NAME, profile);
    }

    public URI getPicture() {
        return this.getURIClaim(PICTURE_CLAIM_NAME);
    }

    public void setPicture(URI picture) {
        this.setURIClaim(PICTURE_CLAIM_NAME, picture);
    }

    public URI getWebsite() {
        return this.getURIClaim(WEBSITE_CLAIM_NAME);
    }

    public void setWebsite(URI website) {
        this.setURIClaim(WEBSITE_CLAIM_NAME, website);
    }

    @Deprecated
    public InternetAddress getEmail() {
        return this.getEmailClaim(EMAIL_CLAIM_NAME);
    }

    @Deprecated
    public void setEmail(InternetAddress email) {
        this.setEmailClaim(EMAIL_CLAIM_NAME, email);
    }

    public String getEmailAddress() {
        return this.getStringClaim(EMAIL_CLAIM_NAME);
    }

    public void setEmailAddress(String email) {
        this.setClaim(EMAIL_CLAIM_NAME, email);
    }

    public Boolean getEmailVerified() {
        return this.getBooleanClaim(EMAIL_VERIFIED_CLAIM_NAME);
    }

    public void setEmailVerified(Boolean emailVerified) {
        this.setClaim(EMAIL_VERIFIED_CLAIM_NAME, emailVerified);
    }

    public Gender getGender() {
        String value = this.getStringClaim(GENDER_CLAIM_NAME);
        if (value == null) {
            return null;
        }
        return new Gender(value);
    }

    public void setGender(Gender gender) {
        if (gender != null) {
            this.setClaim(GENDER_CLAIM_NAME, gender.getValue());
        } else {
            this.setClaim(GENDER_CLAIM_NAME, null);
        }
    }

    public String getBirthdate() {
        return this.getStringClaim(BIRTHDATE_CLAIM_NAME);
    }

    public void setBirthdate(String birthdate) {
        this.setClaim(BIRTHDATE_CLAIM_NAME, birthdate);
    }

    public String getZoneinfo() {
        return this.getStringClaim(ZONEINFO_CLAIM_NAME);
    }

    public void setZoneinfo(String zoneinfo) {
        this.setClaim(ZONEINFO_CLAIM_NAME, zoneinfo);
    }

    public String getLocale() {
        return this.getStringClaim(LOCALE_CLAIM_NAME);
    }

    public void setLocale(String locale) {
        this.setClaim(LOCALE_CLAIM_NAME, locale);
    }

    public String getPhoneNumber() {
        return this.getStringClaim(PHONE_NUMBER_CLAIM_NAME);
    }

    public void setPhoneNumber(String phoneNumber) {
        this.setClaim(PHONE_NUMBER_CLAIM_NAME, phoneNumber);
    }

    public Boolean getPhoneNumberVerified() {
        return this.getBooleanClaim(PHONE_NUMBER_VERIFIED_CLAIM_NAME);
    }

    public void setPhoneNumberVerified(Boolean phoneNumberVerified) {
        this.setClaim(PHONE_NUMBER_VERIFIED_CLAIM_NAME, phoneNumberVerified);
    }

    public Address getAddress() {
        return this.getAddress(null);
    }

    public Address getAddress(LangTag langTag) {
        String name = langTag != null ? "address#" + langTag : ADDRESS_CLAIM_NAME;
        JSONObject jsonObject = this.getClaim(name, JSONObject.class);
        if (jsonObject == null) {
            return null;
        }
        return new Address(jsonObject);
    }

    public Map<LangTag, Address> getAddressEntries() {
        Map<LangTag, JSONObject> entriesIn = this.getLangTaggedClaim(ADDRESS_CLAIM_NAME, JSONObject.class);
        HashMap<LangTag, Address> entriesOut = new HashMap<LangTag, Address>();
        for (Map.Entry<LangTag, JSONObject> en : entriesIn.entrySet()) {
            entriesOut.put(en.getKey(), new Address(en.getValue()));
        }
        return entriesOut;
    }

    public void setAddress(Address address) {
        if (address != null) {
            this.setClaim(ADDRESS_CLAIM_NAME, address.toJSONObject());
        } else {
            this.setClaim(ADDRESS_CLAIM_NAME, null);
        }
    }

    public void setAddress(Address address, LangTag langTag) {
        String key;
        String string = key = langTag == null ? ADDRESS_CLAIM_NAME : "address#" + langTag;
        if (address != null) {
            this.setClaim(key, address.toJSONObject());
        } else {
            this.setClaim(key, null);
        }
    }

    public Date getUpdatedTime() {
        return this.getDateClaim(UPDATED_AT_CLAIM_NAME);
    }

    public void setUpdatedTime(Date updatedTime) {
        this.setDateClaim(UPDATED_AT_CLAIM_NAME, updatedTime);
    }

    public void addAggregatedClaims(AggregatedClaims aggregatedClaims) {
        if (aggregatedClaims == null) {
            return;
        }
        aggregatedClaims.mergeInto(this.claims);
    }

    public Set<AggregatedClaims> getAggregatedClaims() {
        Map<String, JSONObject> claimSources = ExternalClaimsUtils.getExternalClaimSources(this.claims);
        if (claimSources == null) {
            return null;
        }
        HashSet<AggregatedClaims> aggregatedClaimsSet = new HashSet<AggregatedClaims>();
        for (Map.Entry<String, JSONObject> en : claimSources.entrySet()) {
            JWT claimsJWT;
            String sourceID = en.getKey();
            JSONObject sourceSpec = en.getValue();
            Object jwtValue = sourceSpec.get((Object)"JWT");
            if (!(jwtValue instanceof String)) continue;
            try {
                claimsJWT = JWTParser.parse((String)((String)jwtValue));
            }
            catch (java.text.ParseException parseException) {
                continue;
            }
            Set<String> claimNames = ExternalClaimsUtils.getExternalClaimNamesForSource(this.claims, sourceID);
            if (claimNames.isEmpty()) continue;
            aggregatedClaimsSet.add(new AggregatedClaims(sourceID, claimNames, claimsJWT));
        }
        if (aggregatedClaimsSet.isEmpty()) {
            return null;
        }
        return aggregatedClaimsSet;
    }

    public void addDistributedClaims(DistributedClaims distributedClaims) {
        if (distributedClaims == null) {
            return;
        }
        distributedClaims.mergeInto(this.claims);
    }

    public Set<DistributedClaims> getDistributedClaims() {
        Map<String, JSONObject> claimSources = ExternalClaimsUtils.getExternalClaimSources(this.claims);
        if (claimSources == null) {
            return null;
        }
        HashSet<DistributedClaims> distributedClaimsSet = new HashSet<DistributedClaims>();
        for (Map.Entry<String, JSONObject> en : claimSources.entrySet()) {
            Set<String> claimNames;
            URI endpoint;
            String sourceID = en.getKey();
            JSONObject sourceSpec = en.getValue();
            Object endpointValue = sourceSpec.get((Object)"endpoint");
            if (!(endpointValue instanceof String)) continue;
            try {
                endpoint = new URI((String)endpointValue);
            }
            catch (URISyntaxException uRISyntaxException) {
                continue;
            }
            TypelessAccessToken accessToken = null;
            Object accessTokenValue = sourceSpec.get((Object)"access_token");
            if (accessTokenValue instanceof String) {
                accessToken = new TypelessAccessToken((String)accessTokenValue);
            }
            if ((claimNames = ExternalClaimsUtils.getExternalClaimNamesForSource(this.claims, sourceID)).isEmpty()) continue;
            distributedClaimsSet.add(new DistributedClaims(sourceID, claimNames, endpoint, accessToken));
        }
        if (distributedClaimsSet.isEmpty()) {
            return null;
        }
        return distributedClaimsSet;
    }

    public static UserInfo parse(String json) throws ParseException {
        JSONObject jsonObject = JSONObjectUtils.parse(json);
        try {
            return new UserInfo(jsonObject);
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(e.getMessage(), e);
        }
    }
}

