/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.util.common;

import com.mockrunner.util.common.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public class ClassUtil {
    private static final String[] KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictFP", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"};

    public static String getPackageName(Class<?> clazz) {
        Package classPackage = clazz.getPackage();
        if (null == classPackage) {
            return "";
        }
        return classPackage.getName();
    }

    public static String getClassName(Class<?> clazz) {
        String dimensions = "";
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
            dimensions = dimensions + "[]";
        }
        String classPackage = ClassUtil.getPackageName(clazz);
        if (classPackage.length() == 0) {
            return clazz.getName() + dimensions;
        }
        return clazz.getName().substring(classPackage.length() + 1) + dimensions;
    }

    public static Class<?>[] getImplementedInterfaces(Class<?> clazz) {
        if (clazz.isInterface()) {
            return new Class[0];
        }
        Class<?>[] classes = ClassUtil.getInheritanceHierarchy(clazz);
        HashSet interfaceSet = new HashSet();
        for (Class<?> aClass : classes) {
            interfaceSet.addAll(Arrays.asList(aClass.getInterfaces()));
        }
        return interfaceSet.toArray(new Class[interfaceSet.size()]);
    }

    public static Class<?>[] getInheritanceHierarchy(Class<?> clazz) {
        ArrayList classes = new ArrayList();
        for (Class<?> currentClass = clazz; null != currentClass; currentClass = currentClass.getSuperclass()) {
            classes.add(currentClass);
        }
        Collections.reverse(classes);
        return classes.toArray(new Class[classes.size()]);
    }

    public static boolean isKeyword(String name) {
        for (String KEYWORD : KEYWORDS) {
            if (!KEYWORD.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static String getArgumentName(Class<?> argumentType) {
        int index;
        String dimensions = "";
        while (argumentType.isArray()) {
            argumentType = argumentType.getComponentType();
            dimensions = "s";
        }
        String name = ClassUtil.getClassName(argumentType);
        for (index = 0; index < name.length() - 1 && Character.isUpperCase(name.charAt(index)) && Character.isUpperCase(name.charAt(index + 1)); ++index) {
        }
        if (index == name.length() - 1) {
            ++index;
        }
        if (ClassUtil.isKeyword(name = StringUtil.lowerCase(name, 0, index))) {
            name = name + "Value";
        }
        name = name + dimensions;
        return name;
    }
}

