/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.util;

import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import junit.framework.TestCase;

public class StreamUtilTest
extends TestCase {
    public void testGetStreamAsByteArray() throws Exception {
        String expectedString = "This is a simple test string";
        byte[] testData = StreamUtil.getStreamAsByteArray(new ByteArrayInputStream(expectedString.getBytes("ISO-8859-1")));
        String testString = new String(testData);
        StreamUtilTest.assertEquals((String)expectedString, (String)testString);
        testData = StreamUtil.getStreamAsByteArray(new ByteArrayInputStream(expectedString.getBytes("ISO-8859-1")), 3);
        testString = new String(testData);
        StreamUtilTest.assertEquals((String)"Thi", (String)testString);
    }

    public void testGetReaderAsString() {
        String expectedString = "This is a simple test string";
        String testString = StreamUtil.getReaderAsString(new StringReader(expectedString));
        StreamUtilTest.assertEquals((String)expectedString, (String)testString);
        testString = StreamUtil.getReaderAsString(new StringReader(expectedString), 0);
        StreamUtilTest.assertEquals((String)"", (String)testString);
    }

    public void testCompareStreamsAndReader() throws Exception {
        byte[] sourceArray = new byte[]{1, 2, 3, 4, 5};
        byte[] targetArray = new byte[]{1, 2, 3, 4, 5};
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(sourceArray);
        StreamUtilTest.assertTrue((boolean)StreamUtil.compareStreams(sourceStream, new ByteArrayInputStream(targetArray)));
        StreamUtilTest.assertTrue((boolean)StreamUtil.compareStreams(sourceStream, new ByteArrayInputStream(targetArray)));
        StreamUtilTest.assertTrue((1 == ((InputStream)sourceStream).read() ? 1 : 0) != 0);
        StreamUtilTest.assertFalse((boolean)StreamUtil.compareStreams(new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 6}), new ByteArrayInputStream(targetArray)));
        StreamUtilTest.assertFalse((boolean)StreamUtil.compareStreams(new ByteArrayInputStream(new byte[0]), new ByteArrayInputStream(targetArray)));
        String sourceString = "This is a test";
        String targetString = "This is a test";
        StringReader sourceReader = new StringReader(sourceString);
        StreamUtilTest.assertTrue((boolean)StreamUtil.compareReaders(sourceReader, new StringReader(targetString)));
        StreamUtilTest.assertTrue(('T' == (char)sourceReader.read() ? 1 : 0) != 0);
        StreamUtilTest.assertTrue((boolean)StreamUtil.compareReaders(sourceReader, new StringReader("his is a test")));
        StreamUtilTest.assertFalse((boolean)StreamUtil.compareReaders(sourceReader, new StringReader("This is a test")));
        StreamUtilTest.assertFalse((boolean)StreamUtil.compareReaders(new StringReader("this is a test"), new StringReader("This is a test")));
    }

    public void testCopyStreamAndReader() throws Exception {
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(new byte[]{1, 2, 3, 4, 5});
        InputStream copyStream = StreamUtil.copyStream(sourceStream);
        StreamUtilTest.assertTrue((boolean)StreamUtil.compareStreams(sourceStream, copyStream));
        StreamUtilTest.assertEquals((int)1, (int)copyStream.read());
        StreamUtilTest.assertFalse((boolean)StreamUtil.compareStreams(sourceStream, copyStream));
        StringReader sourceReader = new StringReader("This is a String");
        Reader copyReader = StreamUtil.copyReader(sourceReader);
        StreamUtilTest.assertTrue((boolean)StreamUtil.compareReaders(sourceReader, copyReader));
        StreamUtilTest.assertEquals((int)84, (int)copyReader.read());
    }

    public void testGetLinesFromReader() {
        String testString = "This is line1\nThis is line2\nThis is line3";
        StringReader reader = new StringReader(testString);
        List<String> lines = StreamUtil.getLinesFromReader(reader);
        StreamUtilTest.assertEquals((int)3, (int)lines.size());
        StreamUtilTest.assertEquals((Object)"This is line1", (Object)lines.get(0));
        StreamUtilTest.assertEquals((Object)"This is line2", (Object)lines.get(1));
        StreamUtilTest.assertEquals((Object)"This is line3", (Object)lines.get(2));
    }
}

