/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.proc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class PackageImportSorter {
    private String[] order = new String[4];

    public PackageImportSorter() {
        this.order[0] = "java";
        this.order[1] = "javax";
        this.order[2] = "org";
        this.order[3] = "com";
    }

    public List<Set<String>> sortBlocks(List<String> imports) {
        HashMap<String, Group> groups = new HashMap<String, Group>();
        TreeSet<String> sortedGroups = new TreeSet<String>();
        ArrayList<Set<String>> resultList = new ArrayList<Set<String>>();
        this.initializeGroups(imports, groups, sortedGroups);
        if (groups.isEmpty()) {
            this.prepareSingleBlock(imports, resultList);
            return resultList;
        }
        this.classifyImports(groups, sortedGroups);
        this.prepareResultList(groups, resultList);
        return resultList;
    }

    private void prepareSingleBlock(List<String> imports, List<Set<String>> resultList) {
        TreeSet<String> block = new TreeSet<String>(imports);
        resultList.add(block);
    }

    private List<String> getGroupsAsSortedList() {
        TreeSet allGroupSet = new TreeSet();
        Collections.addAll(allGroupSet, this.order);
        ArrayList<String> allGroups = new ArrayList<String>(allGroupSet);
        Collections.reverse(allGroups);
        return allGroups;
    }

    private void prepareResultList(Map<String, Group> groups, List<Set<String>> resultList) {
        for (String anOrder : this.order) {
            Group currentGroup = groups.get(anOrder);
            if (null == currentGroup) continue;
            this.addIfNotEmpty(resultList, currentGroup.getBeforeGroup());
            this.addIfNotEmpty(resultList, currentGroup.getActualGroup());
            this.addIfNotEmpty(resultList, currentGroup.getAfterGroup());
        }
    }

    private void addIfNotEmpty(List<Set<String>> list, Set<String> set) {
        if (null == set || set.isEmpty()) {
            return;
        }
        list.add(set);
    }

    private void initializeGroups(List<String> imports, Map<String, Group> groups, Set<String> sortedGroups) {
        List<String> allGroups = this.getGroupsAsSortedList();
        sortedGroups.addAll(imports);
        Iterator<String> iterator = imports.iterator();
        while (iterator.hasNext()) {
            String anImport;
            String currentImport = anImport = iterator.next();
            this.createGroupIfMatching(allGroups, groups, sortedGroups, currentImport);
        }
        sortedGroups.addAll(groups.keySet());
    }

    private void createGroupIfMatching(List<String> allGroups, Map<String, Group> groups, Set<String> sortedGroups, String currentImport) {
        for (String groupName : allGroups) {
            if (!currentImport.startsWith(groupName)) continue;
            Group group = this.getGroupByName(groups, groupName);
            group.addToActualGroup(currentImport);
            sortedGroups.remove(currentImport);
            return;
        }
    }

    private Group getGroupByName(Map<String, Group> groups, String groupName) {
        Group group = groups.get(groupName);
        if (null == group) {
            group = new Group(groupName);
            groups.put(groupName, group);
        }
        return group;
    }

    private void classifyImports(Map<String, Group> groups, Set<String> sortedGroups) {
        Group currentGroup = null;
        TreeSet<String> tempBeforeGroup = new TreeSet<String>();
        for (String currentImport : sortedGroups) {
            Group tempGroup = groups.get(currentImport);
            currentGroup = this.handleTempGroup(currentGroup, tempBeforeGroup, currentImport, tempGroup);
        }
    }

    private Group handleTempGroup(Group currentGroup, Set<String> tempBeforeGroup, String currentImport, Group tempGroup) {
        if (null != tempGroup) {
            if (null == currentGroup) {
                tempGroup.addAllToBeforeGroup(tempBeforeGroup);
            }
            currentGroup = tempGroup;
        } else if (null == currentGroup) {
            tempBeforeGroup.add(currentImport);
        } else {
            currentGroup.addToAfterGroup(currentImport);
        }
        return currentGroup;
    }

    private class Group {
        private String groupName;
        private Set<String> beforeGroup;
        private Set<String> actualGroup;
        private Set<String> afterGroup;

        public Group(String groupName) {
            this.groupName = groupName;
            this.beforeGroup = new TreeSet<String>();
            this.actualGroup = new TreeSet<String>();
            this.afterGroup = new TreeSet<String>();
        }

        public String getGroupName() {
            return this.groupName;
        }

        public Set<String> getActualGroup() {
            return this.actualGroup;
        }

        public Set<String> getAfterGroup() {
            return this.afterGroup;
        }

        public Set<String> getBeforeGroup() {
            return this.beforeGroup;
        }

        public void addAllToBeforeGroup(Set<String> importSet) {
            this.beforeGroup.addAll(importSet);
        }

        public void addAllToActualGroup(Set<String> importSet) {
            this.actualGroup.addAll(importSet);
        }

        public void addAllToAfterGroup(Set<String> importSet) {
            this.afterGroup.addAll(importSet);
        }

        public void addToBeforeGroup(String importString) {
            this.beforeGroup.add(importString);
        }

        public void addToActualGroup(String importString) {
            this.actualGroup.add(importString);
        }

        public void addToAfterGroup(String importString) {
            this.afterGroup.add(importString);
        }
    }
}

