/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.proc;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JavaLineParser {
    private List<String> linesToParse = new ArrayList<String>();
    private List<String> blocksToParse = new ArrayList<String>();

    public void addLine(String line) {
        this.linesToParse.add(line);
    }

    public void addLines(List<String> lines) {
        this.linesToParse.addAll(lines);
    }

    public void addBlock(String blockLine) {
        this.blocksToParse.add(blockLine);
    }

    public void addBlocks(List<String> blocks) {
        this.blocksToParse.addAll(blocks);
    }

    public List<Line> parse(String source) {
        ArrayList<Line> resultList = new ArrayList<Line>();
        ArrayList<String> tempLinesToParse = new ArrayList<String>(this.linesToParse);
        ArrayList<String> tempBlocksToParse = new ArrayList<String>(this.blocksToParse);
        LineNumberReader input = new LineNumberReader(new StringReader(source));
        String currentLine = null;
        try {
            while (null != (currentLine = input.readLine())) {
                String line = this.checkLine(currentLine, this.linesToParse);
                if (line != null) {
                    resultList.add(new Line(currentLine, input.getLineNumber()));
                    tempLinesToParse.remove(line);
                    continue;
                }
                line = this.checkBlock(currentLine, this.blocksToParse);
                if (line == null) continue;
                int startLineNumber = input.getLineNumber();
                int endLineNumber = this.determineEndLineNumber(input);
                if (endLineNumber <= startLineNumber) continue;
                resultList.add(new Block(currentLine, startLineNumber, endLineNumber));
                tempBlocksToParse.remove(line);
            }
        }
        catch (IOException exc) {
            throw new RuntimeException(exc.getMessage());
        }
        this.checkLinesOrBlocksLeft(tempLinesToParse, tempBlocksToParse);
        return resultList;
    }

    private void checkLinesOrBlocksLeft(List<String> tempLinesToParse, List<String> tempBlocksToParse) {
        StringBuilder message = new StringBuilder("");
        if (tempLinesToParse.size() > 0) {
            message.append("Lines not found:\n");
            for (String aTempLinesToParse : tempLinesToParse) {
                message.append(aTempLinesToParse.toString()).append("\n");
            }
        }
        if (tempBlocksToParse.size() > 0) {
            message.append("Blocks not found:\n");
            for (String aTempBlocksToParse : tempBlocksToParse) {
                message.append(aTempBlocksToParse.toString()).append("\n");
            }
        }
        if (message.length() > 0) {
            throw new RuntimeException(message.toString());
        }
    }

    private String checkLine(String currentLine, List<String> linesToParse) {
        Iterator<String> iterator = linesToParse.iterator();
        while (iterator.hasNext()) {
            String aLinesToParse;
            String nextLine = aLinesToParse = iterator.next();
            if (!currentLine.trim().contains(nextLine)) continue;
            return nextLine;
        }
        return null;
    }

    private String checkBlock(String currentLine, List<String> blocksToParse) {
        Iterator<String> iterator = blocksToParse.iterator();
        while (iterator.hasNext()) {
            String aBlocksToParse;
            String nextLine = aBlocksToParse = iterator.next();
            if (!currentLine.trim().contains(nextLine)) continue;
            return nextLine;
        }
        return null;
    }

    private int determineEndLineNumber(LineNumberReader input) {
        String currentLine = null;
        try {
            while (null != (currentLine = input.readLine()) && !currentLine.trim().contains("{")) {
            }
            int level = 1;
            while (level > 0 && null != (currentLine = input.readLine())) {
                if (currentLine.trim().contains("{")) {
                    ++level;
                    continue;
                }
                if (!currentLine.trim().contains("}")) continue;
                --level;
            }
            if (level == 0) {
                return input.getLineNumber();
            }
            return -1;
        }
        catch (IOException exc) {
            throw new RuntimeException(exc.getMessage());
        }
    }

    public static class Block
    extends Line {
        private int endLineNumber;

        public Block(String line, int lineNumber, int endLineNumber) {
            super(line, lineNumber);
            this.endLineNumber = endLineNumber;
        }

        public int getEndLineNumber() {
            return this.endLineNumber;
        }
    }

    public static class Line {
        private String line;
        private int lineNumber;

        public Line(String line, int lineNumber) {
            this.line = line;
            this.lineNumber = lineNumber;
        }

        public String getLine() {
            return this.line;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

