/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.util.proxy;

import com.jpattern.javassist.CannotCompileException;
import com.jpattern.javassist.bytecode.ClassFile;
import com.jpattern.javassist.util.proxy.SecurityActions;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;

public class FactoryHelper {
    private static Method defineClass1;
    private static Method defineClass2;
    public static final Class[] primitiveTypes;
    public static final String[] wrapperTypes;
    public static final String[] wrapperDesc;
    public static final String[] unwarpMethods;
    public static final String[] unwrapDesc;
    public static final int[] dataSize;

    public static final int typeIndex(Class clazz) {
        Class[] classArray = primitiveTypes;
        int n = classArray.length;
        for (int i = 0; i < n; ++i) {
            if (classArray[i] != clazz) continue;
            return i;
        }
        throw new RuntimeException("bad type:" + clazz.getName());
    }

    public static Class toClass(ClassFile classFile, ClassLoader classLoader) throws CannotCompileException {
        return FactoryHelper.toClass(classFile, classLoader, null);
    }

    public static Class toClass(ClassFile classFile, ClassLoader classLoader, ProtectionDomain protectionDomain) throws CannotCompileException {
        try {
            Object[] objectArray;
            Method method;
            byte[] byArray = FactoryHelper.toBytecode(classFile);
            if (protectionDomain == null) {
                method = defineClass1;
                objectArray = new Object[]{classFile.getName(), byArray, new Integer(0), new Integer(byArray.length)};
            } else {
                method = defineClass2;
                objectArray = new Object[]{classFile.getName(), byArray, new Integer(0), new Integer(byArray.length), protectionDomain};
            }
            return FactoryHelper.toClass2(method, classLoader, objectArray);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CannotCompileException(invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new CannotCompileException(exception);
        }
    }

    private static synchronized Class toClass2(Method method, ClassLoader classLoader, Object[] objectArray) throws Exception {
        SecurityActions.setAccessible(method, true);
        Class clazz = (Class)method.invoke((Object)classLoader, objectArray);
        SecurityActions.setAccessible(method, false);
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toBytecode(ClassFile classFile) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            classFile.write(dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeFile(ClassFile classFile, String string) throws CannotCompileException {
        try {
            FactoryHelper.writeFile0(classFile, string);
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
    }

    private static void writeFile0(ClassFile classFile, String string) throws CannotCompileException, IOException {
        Object object;
        String string2 = classFile.getName();
        String string3 = string + File.separatorChar + string2.replace('.', File.separatorChar) + ".class";
        int n = string3.lastIndexOf(File.separatorChar);
        if (n > 0 && !((String)(object = string3.substring(0, n))).equals(".")) {
            new File((String)object).mkdirs();
        }
        object = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string3)));
        try {
            classFile.write((DataOutputStream)object);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            ((FilterOutputStream)object).close();
        }
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.lang.ClassLoader");
            defineClass1 = SecurityActions.getDeclaredMethod(clazz, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});
            defineClass2 = SecurityActions.getDeclaredMethod(clazz, "defineClass", new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class});
        }
        catch (Exception exception) {
            throw new RuntimeException("cannot initialize");
        }
        primitiveTypes = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE};
        wrapperTypes = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Void"};
        wrapperDesc = new String[]{"(Z)V", "(B)V", "(C)V", "(S)V", "(I)V", "(J)V", "(F)V", "(D)V"};
        unwarpMethods = new String[]{"booleanValue", "byteValue", "charValue", "shortValue", "intValue", "longValue", "floatValue", "doubleValue"};
        unwrapDesc = new String[]{"()Z", "()B", "()C", "()S", "()I", "()J", "()F", "()D"};
        dataSize = new int[]{1, 1, 1, 1, 1, 2, 1, 2};
    }
}

