/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.scopedpool;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SoftValueHashMap
extends AbstractMap
implements Map {
    private Map hash;
    private ReferenceQueue queue = new ReferenceQueue();

    public Set entrySet() {
        this.processQueue();
        return this.hash.entrySet();
    }

    private void processQueue() {
        SoftValueRef softValueRef;
        while ((softValueRef = (SoftValueRef)this.queue.poll()) != null) {
            if (softValueRef != (SoftValueRef)this.hash.get(softValueRef.key)) continue;
            this.hash.remove(softValueRef.key);
        }
    }

    public SoftValueHashMap(int n, float f) {
        this.hash = new HashMap(n, f);
    }

    public SoftValueHashMap(int n) {
        this.hash = new HashMap(n);
    }

    public SoftValueHashMap() {
        this.hash = new HashMap();
    }

    public SoftValueHashMap(Map map) {
        this(Math.max(2 * map.size(), 11), 0.75f);
        this.putAll(map);
    }

    @Override
    public int size() {
        this.processQueue();
        return this.hash.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.hash.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        this.processQueue();
        return this.hash.containsKey(object);
    }

    public Object get(Object object) {
        this.processQueue();
        SoftReference softReference = (SoftReference)this.hash.get(object);
        if (softReference != null) {
            return softReference.get();
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        this.processQueue();
        SoftValueRef softValueRef = this.hash.put(object, SoftValueRef.create(object, object2, this.queue));
        if (softValueRef != null) {
            softValueRef = ((SoftReference)softValueRef).get();
        }
        return softValueRef;
    }

    public Object remove(Object object) {
        this.processQueue();
        return this.hash.remove(object);
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    private static class SoftValueRef
    extends SoftReference {
        public Object key;

        private SoftValueRef(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
        }

        private static SoftValueRef create(Object object, Object object2, ReferenceQueue referenceQueue) {
            if (object2 == null) {
                return null;
            }
            return new SoftValueRef(object, object2, referenceQueue);
        }
    }
}

