/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.expr;

import com.jpattern.javassist.CannotCompileException;
import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.CtBehavior;
import com.jpattern.javassist.CtClass;
import com.jpattern.javassist.NotFoundException;
import com.jpattern.javassist.bytecode.BadBytecode;
import com.jpattern.javassist.bytecode.Bytecode;
import com.jpattern.javassist.bytecode.CodeAttribute;
import com.jpattern.javassist.bytecode.CodeIterator;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.MethodInfo;
import com.jpattern.javassist.compiler.CompileError;
import com.jpattern.javassist.compiler.Javac;
import com.jpattern.javassist.compiler.JvstCodeGen;
import com.jpattern.javassist.compiler.JvstTypeChecker;
import com.jpattern.javassist.compiler.ProceedHandler;
import com.jpattern.javassist.compiler.ast.ASTList;
import com.jpattern.javassist.expr.Expr;

public class Instanceof
extends Expr {
    protected Instanceof(int n, CodeIterator codeIterator, CtClass ctClass, MethodInfo methodInfo) {
        super(n, codeIterator, ctClass, methodInfo);
    }

    @Override
    public CtBehavior where() {
        return super.where();
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public String getFileName() {
        return super.getFileName();
    }

    public CtClass getType() throws NotFoundException {
        ConstPool constPool = this.getConstPool();
        int n = this.currentPos;
        int n2 = this.iterator.u16bitAt(n + 1);
        String string = constPool.getClassInfo(n2);
        return this.thisClass.getClassPool().getCtClass(string);
    }

    @Override
    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    @Override
    public void replace(String string) throws CannotCompileException {
        this.thisClass.getClassFile();
        ConstPool constPool = this.getConstPool();
        int n = this.currentPos;
        int n2 = this.iterator.u16bitAt(n + 1);
        Javac javac = new Javac(this.thisClass);
        ClassPool classPool = this.thisClass.getClassPool();
        CodeAttribute codeAttribute = this.iterator.get();
        try {
            CtClass[] ctClassArray = new CtClass[]{classPool.get("java.lang.Object")};
            CtClass ctClass = CtClass.booleanType;
            int n3 = codeAttribute.getMaxLocals();
            javac.recordParams("java.lang.Object", ctClassArray, true, n3, this.withinStatic());
            int n4 = javac.recordReturnType(ctClass, true);
            javac.recordProceed(new ProceedForInstanceof(n2));
            javac.recordType(this.getType());
            Instanceof.checkResultValue(ctClass, string);
            Bytecode bytecode = javac.getBytecode();
            Instanceof.storeStack(ctClassArray, true, n3, bytecode);
            javac.recordLocalVariables(codeAttribute, n);
            bytecode.addConstZero(ctClass);
            bytecode.addStore(n4, ctClass);
            javac.compileStmnt(string);
            bytecode.addLoad(n4, ctClass);
            this.replace0(n, bytecode, 3);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException("broken method");
        }
    }

    static class ProceedForInstanceof
    implements ProceedHandler {
        int index;

        ProceedForInstanceof(int n) {
            this.index = n;
        }

        @Override
        public void doit(JvstCodeGen jvstCodeGen, Bytecode bytecode, ASTList aSTList) throws CompileError {
            if (jvstCodeGen.getMethodArgsLength(aSTList) != 1) {
                throw new CompileError("$proceed() cannot take more than one parameter for instanceof");
            }
            jvstCodeGen.atMethodArgs(aSTList, new int[1], new int[1], new String[1]);
            bytecode.addOpcode(193);
            bytecode.addIndex(this.index);
            jvstCodeGen.setType(CtClass.booleanType);
        }

        @Override
        public void setReturnType(JvstTypeChecker jvstTypeChecker, ASTList aSTList) throws CompileError {
            jvstTypeChecker.atMethodArgs(aSTList, new int[1], new int[1], new String[1]);
            jvstTypeChecker.setType(CtClass.booleanType);
        }
    }
}

