/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.expr;

import com.jpattern.javassist.CannotCompileException;
import com.jpattern.javassist.CtBehavior;
import com.jpattern.javassist.CtClass;
import com.jpattern.javassist.NotFoundException;
import com.jpattern.javassist.bytecode.Bytecode;
import com.jpattern.javassist.bytecode.CodeAttribute;
import com.jpattern.javassist.bytecode.CodeIterator;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.ExceptionTable;
import com.jpattern.javassist.bytecode.MethodInfo;
import com.jpattern.javassist.compiler.CompileError;
import com.jpattern.javassist.compiler.Javac;
import com.jpattern.javassist.expr.Expr;

public class Handler
extends Expr {
    private static String EXCEPTION_NAME = "$1";
    private ExceptionTable etable;
    private int index;

    protected Handler(ExceptionTable exceptionTable, int n, CodeIterator codeIterator, CtClass ctClass, MethodInfo methodInfo) {
        super(exceptionTable.handlerPc(n), codeIterator, ctClass, methodInfo);
        this.etable = exceptionTable;
        this.index = n;
    }

    @Override
    public CtBehavior where() {
        return super.where();
    }

    @Override
    public int getLineNumber() {
        return super.getLineNumber();
    }

    @Override
    public String getFileName() {
        return super.getFileName();
    }

    @Override
    public CtClass[] mayThrow() {
        return super.mayThrow();
    }

    public CtClass getType() throws NotFoundException {
        int n = this.etable.catchType(this.index);
        if (n == 0) {
            return null;
        }
        ConstPool constPool = this.getConstPool();
        String string = constPool.getClassInfo(n);
        return this.thisClass.getClassPool().getCtClass(string);
    }

    public boolean isFinally() {
        return this.etable.catchType(this.index) == 0;
    }

    @Override
    public void replace(String string) throws CannotCompileException {
        throw new RuntimeException("not implemented yet");
    }

    public void insertBefore(String string) throws CannotCompileException {
        this.edited = true;
        ConstPool constPool = this.getConstPool();
        CodeAttribute codeAttribute = this.iterator.get();
        Javac javac = new Javac(this.thisClass);
        Bytecode bytecode = javac.getBytecode();
        bytecode.setStackDepth(1);
        bytecode.setMaxLocals(codeAttribute.getMaxLocals());
        try {
            CtClass ctClass = this.getType();
            int n = javac.recordVariable(ctClass, EXCEPTION_NAME);
            javac.recordReturnType(ctClass, false);
            bytecode.addAstore(n);
            javac.compileStmnt(string);
            bytecode.addAload(n);
            int n2 = this.etable.handlerPc(this.index);
            bytecode.addOpcode(167);
            bytecode.addIndex(n2 - this.iterator.getCodeLength() - bytecode.currentPc() + 1);
            this.maxStack = bytecode.getMaxStack();
            this.maxLocals = bytecode.getMaxLocals();
            int n3 = this.iterator.append(bytecode.get());
            this.iterator.append(bytecode.getExceptionTable(), n3);
            this.etable.setHandlerPc(this.index, n3);
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
    }
}

