/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.compiler;

import com.jpattern.javassist.CannotCompileException;
import com.jpattern.javassist.CtBehavior;
import com.jpattern.javassist.CtClass;
import com.jpattern.javassist.CtConstructor;
import com.jpattern.javassist.CtField;
import com.jpattern.javassist.CtMember;
import com.jpattern.javassist.CtMethod;
import com.jpattern.javassist.CtPrimitiveType;
import com.jpattern.javassist.Modifier;
import com.jpattern.javassist.NotFoundException;
import com.jpattern.javassist.bytecode.BadBytecode;
import com.jpattern.javassist.bytecode.Bytecode;
import com.jpattern.javassist.bytecode.CodeAttribute;
import com.jpattern.javassist.bytecode.LocalVariableAttribute;
import com.jpattern.javassist.compiler.CompileError;
import com.jpattern.javassist.compiler.JvstCodeGen;
import com.jpattern.javassist.compiler.JvstTypeChecker;
import com.jpattern.javassist.compiler.Lex;
import com.jpattern.javassist.compiler.MemberResolver;
import com.jpattern.javassist.compiler.Parser;
import com.jpattern.javassist.compiler.ProceedHandler;
import com.jpattern.javassist.compiler.SymbolTable;
import com.jpattern.javassist.compiler.ast.ASTList;
import com.jpattern.javassist.compiler.ast.ASTree;
import com.jpattern.javassist.compiler.ast.CallExpr;
import com.jpattern.javassist.compiler.ast.Declarator;
import com.jpattern.javassist.compiler.ast.Expr;
import com.jpattern.javassist.compiler.ast.FieldDecl;
import com.jpattern.javassist.compiler.ast.Member;
import com.jpattern.javassist.compiler.ast.MethodDecl;
import com.jpattern.javassist.compiler.ast.Stmnt;
import com.jpattern.javassist.compiler.ast.Symbol;

public class Javac {
    JvstCodeGen gen;
    SymbolTable stable;
    private Bytecode bytecode;
    public static final String param0Name = "$0";
    public static final String resultVarName = "$_";
    public static final String proceedName = "$proceed";

    public Javac(CtClass ctClass) {
        this(new Bytecode(ctClass.getClassFile2().getConstPool(), 0, 0), ctClass);
    }

    public Javac(Bytecode bytecode, CtClass ctClass) {
        this.gen = new JvstCodeGen(bytecode, ctClass, ctClass.getClassPool());
        this.stable = new SymbolTable();
        this.bytecode = bytecode;
    }

    public Bytecode getBytecode() {
        return this.bytecode;
    }

    public CtMember compile(String string) throws CompileError {
        Parser parser = new Parser(new Lex(string));
        ASTList aSTList = parser.parseMember1(this.stable);
        try {
            if (aSTList instanceof FieldDecl) {
                return this.compileField((FieldDecl)aSTList);
            }
            CtBehavior ctBehavior = this.compileMethod(parser, (MethodDecl)aSTList);
            CtClass ctClass = ctBehavior.getDeclaringClass();
            ctBehavior.getMethodInfo2().rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
            return ctBehavior;
        }
        catch (BadBytecode badBytecode) {
            throw new CompileError(badBytecode.getMessage());
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CompileError(cannotCompileException.getMessage());
        }
    }

    private CtField compileField(FieldDecl fieldDecl) throws CompileError, CannotCompileException {
        Declarator declarator = fieldDecl.getDeclarator();
        CtFieldWithInit ctFieldWithInit = new CtFieldWithInit(this.gen.resolver.lookupClass(declarator), declarator.getVariable().get(), this.gen.getThisClass());
        ctFieldWithInit.setModifiers(MemberResolver.getModifiers(fieldDecl.getModifiers()));
        if (fieldDecl.getInit() != null) {
            ctFieldWithInit.setInit(fieldDecl.getInit());
        }
        return ctFieldWithInit;
    }

    private CtBehavior compileMethod(Parser parser, MethodDecl methodDecl) throws CompileError {
        int n = MemberResolver.getModifiers(methodDecl.getModifiers());
        CtClass[] ctClassArray = this.gen.makeParamList(methodDecl);
        CtClass[] ctClassArray2 = this.gen.makeThrowsList(methodDecl);
        this.recordParams(ctClassArray, Modifier.isStatic(n));
        methodDecl = parser.parseMethod2(this.stable, methodDecl);
        try {
            if (methodDecl.isConstructor()) {
                CtConstructor ctConstructor = new CtConstructor(ctClassArray, this.gen.getThisClass());
                ctConstructor.setModifiers(n);
                methodDecl.accept(this.gen);
                ctConstructor.getMethodInfo().setCodeAttribute(this.bytecode.toCodeAttribute());
                ctConstructor.setExceptionTypes(ctClassArray2);
                return ctConstructor;
            }
            Declarator declarator = methodDecl.getReturn();
            CtClass ctClass = this.gen.resolver.lookupClass(declarator);
            this.recordReturnType(ctClass, false);
            CtMethod ctMethod = new CtMethod(ctClass, declarator.getVariable().get(), ctClassArray, this.gen.getThisClass());
            ctMethod.setModifiers(n);
            this.gen.setThisMethod(ctMethod);
            methodDecl.accept(this.gen);
            if (methodDecl.getBody() != null) {
                ctMethod.getMethodInfo().setCodeAttribute(this.bytecode.toCodeAttribute());
            } else {
                ctMethod.setModifiers(n | 0x400);
            }
            ctMethod.setExceptionTypes(ctClassArray2);
            return ctMethod;
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError(notFoundException.toString());
        }
    }

    public Bytecode compileBody(CtBehavior ctBehavior, String string) throws CompileError {
        try {
            boolean bl;
            CtClass ctClass;
            int n = ctBehavior.getModifiers();
            this.recordParams(ctBehavior.getParameterTypes(), Modifier.isStatic(n));
            if (ctBehavior instanceof CtMethod) {
                this.gen.setThisMethod((CtMethod)ctBehavior);
                ctClass = ((CtMethod)ctBehavior).getReturnType();
            } else {
                ctClass = CtClass.voidType;
            }
            this.recordReturnType(ctClass, false);
            boolean bl2 = bl = ctClass == CtClass.voidType;
            if (string == null) {
                Javac.makeDefaultBody(this.bytecode, ctClass);
            } else {
                Parser parser = new Parser(new Lex(string));
                SymbolTable symbolTable = new SymbolTable(this.stable);
                Stmnt stmnt = parser.parseStatement(symbolTable);
                if (parser.hasMore()) {
                    throw new CompileError("the method/constructor body must be surrounded by {}");
                }
                boolean bl3 = false;
                if (ctBehavior instanceof CtConstructor) {
                    bl3 = !((CtConstructor)ctBehavior).isClassInitializer();
                }
                this.gen.atMethodBody(stmnt, bl3, bl);
            }
            return this.bytecode;
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError(notFoundException.toString());
        }
    }

    private static void makeDefaultBody(Bytecode bytecode, CtClass ctClass) {
        int n;
        int n2;
        if (ctClass instanceof CtPrimitiveType) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)ctClass;
            n2 = ctPrimitiveType.getReturnOp();
            n = n2 == 175 ? 14 : (n2 == 174 ? 11 : (n2 == 173 ? 9 : (n2 == 177 ? 0 : 3)));
        } else {
            n2 = 176;
            n = 1;
        }
        if (n != 0) {
            bytecode.addOpcode(n);
        }
        bytecode.addOpcode(n2);
    }

    public boolean recordLocalVariables(CodeAttribute codeAttribute, int n) throws CompileError {
        LocalVariableAttribute localVariableAttribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        if (localVariableAttribute == null) {
            return false;
        }
        int n2 = localVariableAttribute.tableLength();
        for (int i = 0; i < n2; ++i) {
            int n3 = localVariableAttribute.startPc(i);
            int n4 = localVariableAttribute.codeLength(i);
            if (n3 > n || n >= n3 + n4) continue;
            this.gen.recordVariable(localVariableAttribute.descriptor(i), localVariableAttribute.variableName(i), localVariableAttribute.index(i), this.stable);
        }
        return true;
    }

    public boolean recordParamNames(CodeAttribute codeAttribute, int n) throws CompileError {
        LocalVariableAttribute localVariableAttribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        if (localVariableAttribute == null) {
            return false;
        }
        int n2 = localVariableAttribute.tableLength();
        for (int i = 0; i < n2; ++i) {
            int n3 = localVariableAttribute.index(i);
            if (n3 >= n) continue;
            this.gen.recordVariable(localVariableAttribute.descriptor(i), localVariableAttribute.variableName(i), n3, this.stable);
        }
        return true;
    }

    public int recordParams(CtClass[] ctClassArray, boolean bl) throws CompileError {
        return this.gen.recordParams(ctClassArray, bl, "$", "$args", "$$", this.stable);
    }

    public int recordParams(String string, CtClass[] ctClassArray, boolean bl, int n, boolean bl2) throws CompileError {
        return this.gen.recordParams(ctClassArray, bl2, "$", "$args", "$$", bl, n, string, this.stable);
    }

    public void setMaxLocals(int n) {
        this.gen.setMaxLocals(n);
    }

    public int recordReturnType(CtClass ctClass, boolean bl) throws CompileError {
        this.gen.recordType(ctClass);
        return this.gen.recordReturnType(ctClass, "$r", bl ? resultVarName : null, this.stable);
    }

    public void recordType(CtClass ctClass) {
        this.gen.recordType(ctClass);
    }

    public int recordVariable(CtClass ctClass, String string) throws CompileError {
        return this.gen.recordVariable(ctClass, string, this.stable);
    }

    public void recordProceed(String string, String string2) throws CompileError {
        Parser parser = new Parser(new Lex(string));
        final ASTree aSTree = parser.parseExpression(this.stable);
        final String string3 = string2;
        ProceedHandler proceedHandler = new ProceedHandler(){

            @Override
            public void doit(JvstCodeGen jvstCodeGen, Bytecode bytecode, ASTList aSTList) throws CompileError {
                ASTree aSTree2 = new Member(string3);
                if (aSTree != null) {
                    aSTree2 = Expr.make(46, aSTree, aSTree2);
                }
                aSTree2 = CallExpr.makeCall(aSTree2, aSTList);
                jvstCodeGen.compileExpr(aSTree2);
                jvstCodeGen.addNullIfVoid();
            }

            @Override
            public void setReturnType(JvstTypeChecker jvstTypeChecker, ASTList aSTList) throws CompileError {
                ASTree aSTree2 = new Member(string3);
                if (aSTree != null) {
                    aSTree2 = Expr.make(46, aSTree, aSTree2);
                }
                aSTree2 = CallExpr.makeCall(aSTree2, aSTList);
                ((ASTree)aSTree2).accept(jvstTypeChecker);
                jvstTypeChecker.addNullIfVoid();
            }
        };
        this.gen.setProceedHandler(proceedHandler, proceedName);
    }

    public void recordStaticProceed(String string, String string2) throws CompileError {
        final String string3 = string;
        final String string4 = string2;
        ProceedHandler proceedHandler = new ProceedHandler(){

            @Override
            public void doit(JvstCodeGen jvstCodeGen, Bytecode bytecode, ASTList aSTList) throws CompileError {
                Expr expr = Expr.make(35, (ASTree)new Symbol(string3), (ASTree)new Member(string4));
                expr = CallExpr.makeCall(expr, aSTList);
                jvstCodeGen.compileExpr(expr);
                jvstCodeGen.addNullIfVoid();
            }

            @Override
            public void setReturnType(JvstTypeChecker jvstTypeChecker, ASTList aSTList) throws CompileError {
                Expr expr = Expr.make(35, (ASTree)new Symbol(string3), (ASTree)new Member(string4));
                expr = CallExpr.makeCall(expr, aSTList);
                expr.accept(jvstTypeChecker);
                jvstTypeChecker.addNullIfVoid();
            }
        };
        this.gen.setProceedHandler(proceedHandler, proceedName);
    }

    public void recordSpecialProceed(String string, String string2, String string3, String string4) throws CompileError {
        Parser parser = new Parser(new Lex(string));
        final ASTree aSTree = parser.parseExpression(this.stable);
        final String string5 = string2;
        final String string6 = string3;
        final String string7 = string4;
        ProceedHandler proceedHandler = new ProceedHandler(){

            @Override
            public void doit(JvstCodeGen jvstCodeGen, Bytecode bytecode, ASTList aSTList) throws CompileError {
                jvstCodeGen.compileInvokeSpecial(aSTree, string5, string6, string7, aSTList);
            }

            @Override
            public void setReturnType(JvstTypeChecker jvstTypeChecker, ASTList aSTList) throws CompileError {
                jvstTypeChecker.compileInvokeSpecial(aSTree, string5, string6, string7, aSTList);
            }
        };
        this.gen.setProceedHandler(proceedHandler, proceedName);
    }

    public void recordProceed(ProceedHandler proceedHandler) {
        this.gen.setProceedHandler(proceedHandler, proceedName);
    }

    public void compileStmnt(String string) throws CompileError {
        Parser parser = new Parser(new Lex(string));
        SymbolTable symbolTable = new SymbolTable(this.stable);
        while (parser.hasMore()) {
            Stmnt stmnt = parser.parseStatement(symbolTable);
            if (stmnt == null) continue;
            stmnt.accept(this.gen);
        }
    }

    public void compileExpr(String string) throws CompileError {
        ASTree aSTree = Javac.parseExpr(string, this.stable);
        this.compileExpr(aSTree);
    }

    public static ASTree parseExpr(String string, SymbolTable symbolTable) throws CompileError {
        Parser parser = new Parser(new Lex(string));
        return parser.parseExpression(symbolTable);
    }

    public void compileExpr(ASTree aSTree) throws CompileError {
        if (aSTree != null) {
            this.gen.compileExpr(aSTree);
        }
    }

    public static class CtFieldWithInit
    extends CtField {
        private ASTree init = null;

        CtFieldWithInit(CtClass ctClass, String string, CtClass ctClass2) throws CannotCompileException {
            super(ctClass, string, ctClass2);
        }

        protected void setInit(ASTree aSTree) {
            this.init = aSTree;
        }

        @Override
        protected ASTree getInitAST() {
            return this.init;
        }
    }
}

