/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.stackmap;

import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.CtClass;
import com.jpattern.javassist.NotFoundException;
import com.jpattern.javassist.bytecode.BadBytecode;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.stackmap.TypeTag;
import java.util.ArrayList;

public abstract class TypeData {
    protected TypeData() {
    }

    public abstract void merge(TypeData var1);

    static void setType(TypeData typeData, String string, ClassPool classPool) throws BadBytecode {
        if (typeData == TypeTag.TOP) {
            throw new BadBytecode("unset variable");
        }
        typeData.setType(string, classPool);
    }

    public abstract boolean equals(Object var1);

    public abstract int getTypeTag();

    public abstract int getTypeData(ConstPool var1);

    public TypeData getSelf() {
        return this;
    }

    public abstract TypeData copy();

    public abstract boolean isObjectType();

    public boolean is2WordType() {
        return false;
    }

    public boolean isNullType() {
        return false;
    }

    public abstract String getName() throws BadBytecode;

    protected abstract void setType(String var1, ClassPool var2) throws BadBytecode;

    public abstract void evalExpectedType(ClassPool var1) throws BadBytecode;

    public abstract String getExpected() throws BadBytecode;

    public static class UninitThis
    extends UninitData {
        UninitThis(String string) {
            super(-1, string);
        }

        @Override
        public int getTypeTag() {
            return 6;
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            return 0;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof UninitThis;
        }

        @Override
        public String toString() {
            return "uninit:this";
        }
    }

    public static class UninitData
    extends TypeData {
        String className;
        int offset;
        boolean initialized;

        UninitData(int n, String string) {
            this.className = string;
            this.offset = n;
            this.initialized = false;
        }

        @Override
        public void merge(TypeData typeData) {
        }

        @Override
        public int getTypeTag() {
            return 8;
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            return this.offset;
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof UninitData) {
                UninitData uninitData = (UninitData)object;
                return this.offset == uninitData.offset && this.className.equals(uninitData.className);
            }
            return false;
        }

        @Override
        public TypeData getSelf() {
            if (this.initialized) {
                return this.copy();
            }
            return this;
        }

        @Override
        public TypeData copy() {
            return new ClassName(this.className);
        }

        @Override
        public boolean isObjectType() {
            return true;
        }

        @Override
        protected void setType(String string, ClassPool classPool) throws BadBytecode {
            this.initialized = true;
        }

        @Override
        public void evalExpectedType(ClassPool classPool) throws BadBytecode {
        }

        @Override
        public String getName() {
            return this.className;
        }

        @Override
        public String getExpected() {
            return this.className;
        }

        public String toString() {
            return "uninit:" + this.className + "@" + this.offset;
        }
    }

    public static class ArrayElement
    extends TypeName {
        TypeData array;

        public ArrayElement(TypeData typeData) {
            this.array = typeData;
        }

        @Override
        public TypeData copy() {
            return new ArrayElement(this.array);
        }

        @Override
        public boolean isNullType() {
            return this.array.isNullType();
        }

        @Override
        protected void setType(String string, ClassPool classPool) throws BadBytecode {
            super.setType(string, classPool);
            this.array.setType(ArrayElement.getArrayType(string), classPool);
        }

        @Override
        public String getName() throws BadBytecode {
            return this.getName2(this.array.getName());
        }

        private String getName2(String string) throws BadBytecode {
            if (string.length() > 1 && string.charAt(0) == '[') {
                char c = string.charAt(1);
                if (c == 'L') {
                    return string.substring(2, string.length() - 1).replace('/', '.');
                }
                if (c == '[') {
                    return string.substring(1);
                }
            }
            if (this.array.isNullType()) {
                return "java.lang.Object";
            }
            throw new BadBytecode("bad array type for AALOAD: " + string);
        }

        @Override
        public String getExpected() throws BadBytecode {
            ArrayList arrayList = this.equivalences;
            if (arrayList.size() == 1) {
                return this.getName2(this.array.getExpected());
            }
            String string = this.expectedName;
            if (string == null) {
                return "java.lang.Object";
            }
            return string;
        }

        public static String getArrayType(String string) {
            if (string.charAt(0) == '[') {
                return "[" + string;
            }
            return "[L" + string.replace('.', '/') + ";";
        }

        public static String getElementType(String string) {
            char c = string.charAt(1);
            if (c == 'L') {
                return string.substring(2, string.length() - 1).replace('/', '.');
            }
            if (c == '[') {
                return string.substring(1);
            }
            return string;
        }
    }

    public static class NullType
    extends ClassName {
        public NullType() {
            super("null");
        }

        @Override
        public TypeData copy() {
            return new NullType();
        }

        @Override
        public boolean isNullType() {
            return true;
        }

        @Override
        public int getTypeTag() {
            try {
                if ("null".equals(this.getExpected())) {
                    return 5;
                }
                return super.getTypeTag();
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException("fatal error: ", badBytecode);
            }
        }

        @Override
        protected int getTypeData2(ConstPool constPool, String string) {
            if ("null".equals(string)) {
                return 0;
            }
            return super.getTypeData2(constPool, string);
        }

        @Override
        public String getExpected() throws BadBytecode {
            String string = this.expectedName;
            if (string == null) {
                return "java.lang.Object";
            }
            return string;
        }
    }

    public static class ClassName
    extends TypeName {
        private String name;

        public ClassName(String string) {
            this.name = string;
        }

        @Override
        public TypeData copy() {
            return new ClassName(this.name);
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    protected static abstract class TypeName
    extends TypeData {
        protected ArrayList equivalences = new ArrayList();
        protected String expectedName;
        private CtClass cache;
        private boolean evalDone;

        protected TypeName() {
            this.equivalences.add(this);
            this.expectedName = null;
            this.cache = null;
            this.evalDone = false;
        }

        @Override
        public void merge(TypeData typeData) {
            if (this == typeData) {
                return;
            }
            if (!(typeData instanceof TypeName)) {
                return;
            }
            TypeName typeName = (TypeName)typeData;
            ArrayList arrayList = this.equivalences;
            ArrayList arrayList2 = typeName.equivalences;
            if (arrayList == arrayList2) {
                return;
            }
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                TypeName typeName2 = (TypeName)arrayList2.get(i);
                TypeName.add(arrayList, typeName2);
                typeName2.equivalences = arrayList;
            }
        }

        private static void add(ArrayList arrayList, TypeData typeData) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (arrayList.get(i) != typeData) continue;
                return;
            }
            arrayList.add(typeData);
        }

        @Override
        public int getTypeTag() {
            return 7;
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            String string;
            try {
                string = this.getExpected();
            }
            catch (BadBytecode badBytecode) {
                throw new RuntimeException("fatal error: ", badBytecode);
            }
            return this.getTypeData2(constPool, string);
        }

        protected int getTypeData2(ConstPool constPool, String string) {
            return constPool.addClassInfo(string);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof TypeName) {
                try {
                    TypeName typeName = (TypeName)object;
                    return this.getExpected().equals(typeName.getExpected());
                }
                catch (BadBytecode badBytecode) {
                    // empty catch block
                }
            }
            return false;
        }

        @Override
        public boolean isObjectType() {
            return true;
        }

        @Override
        protected void setType(String string, ClassPool classPool) throws BadBytecode {
            if (this.update(classPool, this.expectedName, string)) {
                this.expectedName = string;
            }
        }

        @Override
        public void evalExpectedType(ClassPool classPool) throws BadBytecode {
            TypeName typeName;
            TypeData typeData;
            int n;
            if (this.evalDone) {
                return;
            }
            ArrayList arrayList = this.equivalences;
            int n2 = arrayList.size();
            String string = this.evalExpectedType2(arrayList, n2);
            if (string == null) {
                string = this.expectedName;
                for (n = 0; n < n2; ++n) {
                    typeData = (TypeData)arrayList.get(n);
                    if (!(typeData instanceof TypeName)) continue;
                    typeName = (TypeName)typeData;
                    if (!this.update(classPool, string, typeName.expectedName)) continue;
                    string = typeName.expectedName;
                }
            }
            for (n = 0; n < n2; ++n) {
                typeData = (TypeData)arrayList.get(n);
                if (!(typeData instanceof TypeName)) continue;
                typeName = (TypeName)typeData;
                typeName.expectedName = string;
                typeName.cache = null;
                typeName.evalDone = true;
            }
        }

        private String evalExpectedType2(ArrayList arrayList, int n) throws BadBytecode {
            String string = null;
            for (int i = 0; i < n; ++i) {
                TypeData typeData = (TypeData)arrayList.get(i);
                if (typeData.isNullType()) continue;
                if (string == null) {
                    string = typeData.getName();
                    continue;
                }
                if (string.equals(typeData.getName())) continue;
                return null;
            }
            return string;
        }

        protected boolean isTypeName() {
            return true;
        }

        private boolean update(ClassPool classPool, String string, String string2) throws BadBytecode {
            if (string2 == null) {
                return false;
            }
            if (string == null) {
                return true;
            }
            if (string.equals(string2)) {
                return false;
            }
            if (string2.charAt(0) == '[' && string.equals("[Ljava.lang.Object;")) {
                return true;
            }
            try {
                CtClass ctClass;
                if (this.cache == null) {
                    this.cache = classPool.get(string);
                }
                if ((ctClass = classPool.get(string2)).subtypeOf(this.cache)) {
                    this.cache = ctClass;
                    return true;
                }
                return false;
            }
            catch (NotFoundException notFoundException) {
                throw new BadBytecode("cannot find " + notFoundException.getMessage());
            }
        }

        @Override
        public String getExpected() throws BadBytecode {
            ArrayList arrayList = this.equivalences;
            if (arrayList.size() == 1) {
                return this.getName();
            }
            String string = this.expectedName;
            if (string == null) {
                return "java.lang.Object";
            }
            return string;
        }

        public String toString() {
            try {
                String string = this.expectedName;
                if (string != null) {
                    return string;
                }
                String string2 = this.getName();
                if (this.equivalences.size() == 1) {
                    return string2;
                }
                return string2 + "?";
            }
            catch (BadBytecode badBytecode) {
                return "<" + badBytecode.getMessage() + ">";
            }
        }
    }

    protected static class BasicType
    extends TypeData {
        private String name;
        private int typeTag;

        public BasicType(String string, int n) {
            this.name = string;
            this.typeTag = n;
        }

        @Override
        public void merge(TypeData typeData) {
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        @Override
        public int getTypeTag() {
            return this.typeTag;
        }

        @Override
        public int getTypeData(ConstPool constPool) {
            return 0;
        }

        @Override
        public boolean isObjectType() {
            return false;
        }

        @Override
        public boolean is2WordType() {
            return this.typeTag == 4 || this.typeTag == 3;
        }

        @Override
        public TypeData copy() {
            return this;
        }

        @Override
        public void evalExpectedType(ClassPool classPool) throws BadBytecode {
        }

        @Override
        public String getExpected() throws BadBytecode {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        protected void setType(String string, ClassPool classPool) throws BadBytecode {
            throw new BadBytecode("conflict: " + this.name + " and " + string);
        }

        public String toString() {
            return this.name;
        }
    }
}

