/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.annotation;

import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.Descriptor;
import com.jpattern.javassist.bytecode.annotation.AnnotationsWriter;
import com.jpattern.javassist.bytecode.annotation.MemberValueVisitor;
import com.jpattern.javassist.bytecode.annotation.NoSuchClassError;
import java.io.IOException;
import java.lang.reflect.Method;

public abstract class MemberValue {
    ConstPool cp;
    char tag;

    MemberValue(char c, ConstPool constPool) {
        this.cp = constPool;
        this.tag = c;
    }

    abstract Object getValue(ClassLoader var1, ClassPool var2, Method var3) throws ClassNotFoundException;

    abstract Class getType(ClassLoader var1) throws ClassNotFoundException;

    static Class loadClass(ClassLoader classLoader, String string) throws ClassNotFoundException, NoSuchClassError {
        try {
            return Class.forName(MemberValue.convertFromArray(string), true, classLoader);
        }
        catch (LinkageError linkageError) {
            throw new NoSuchClassError(string, linkageError);
        }
    }

    private static String convertFromArray(String string) {
        int n = string.indexOf("[]");
        if (n != -1) {
            String string2 = string.substring(0, n);
            StringBuffer stringBuffer = new StringBuffer(Descriptor.of(string2));
            while (n != -1) {
                stringBuffer.insert(0, "[");
                n = string.indexOf("[]", n + 1);
            }
            return stringBuffer.toString().replace('/', '.');
        }
        return string;
    }

    public abstract void accept(MemberValueVisitor var1);

    public abstract void write(AnnotationsWriter var1) throws IOException;
}

