/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.annotation;

import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.annotation.AnnotationsWriter;
import com.jpattern.javassist.bytecode.annotation.MemberValue;
import com.jpattern.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class LongMemberValue
extends MemberValue {
    int valueIndex;

    public LongMemberValue(int n, ConstPool constPool) {
        super('J', constPool);
        this.valueIndex = n;
    }

    public LongMemberValue(long l, ConstPool constPool) {
        super('J', constPool);
        this.setValue(l);
    }

    public LongMemberValue(ConstPool constPool) {
        super('J', constPool);
        this.setValue(0L);
    }

    @Override
    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Long(this.getValue());
    }

    @Override
    Class getType(ClassLoader classLoader) {
        return Long.TYPE;
    }

    public long getValue() {
        return this.cp.getLongInfo(this.valueIndex);
    }

    public void setValue(long l) {
        this.valueIndex = this.cp.addLongInfo(l);
    }

    public String toString() {
        return Long.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitLongMemberValue(this);
    }
}

