/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.annotation;

import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.annotation.AnnotationsWriter;
import com.jpattern.javassist.bytecode.annotation.MemberValue;
import com.jpattern.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class IntegerMemberValue
extends MemberValue {
    int valueIndex;

    public IntegerMemberValue(int n, ConstPool constPool) {
        super('I', constPool);
        this.valueIndex = n;
    }

    public IntegerMemberValue(ConstPool constPool, int n) {
        super('I', constPool);
        this.setValue(n);
    }

    public IntegerMemberValue(ConstPool constPool) {
        super('I', constPool);
        this.setValue(0);
    }

    @Override
    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) {
        return new Integer(this.getValue());
    }

    @Override
    Class getType(ClassLoader classLoader) {
        return Integer.TYPE;
    }

    public int getValue() {
        return this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(int n) {
        this.valueIndex = this.cp.addIntegerInfo(n);
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitIntegerMemberValue(this);
    }
}

