/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.annotation;

import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.Descriptor;
import com.jpattern.javassist.bytecode.annotation.AnnotationsWriter;
import com.jpattern.javassist.bytecode.annotation.MemberValue;
import com.jpattern.javassist.bytecode.annotation.MemberValueVisitor;
import java.io.IOException;
import java.lang.reflect.Method;

public class ClassMemberValue
extends MemberValue {
    int valueIndex;

    public ClassMemberValue(int n, ConstPool constPool) {
        super('c', constPool);
        this.valueIndex = n;
    }

    public ClassMemberValue(String string, ConstPool constPool) {
        super('c', constPool);
        this.setValue(string);
    }

    public ClassMemberValue(ConstPool constPool) {
        super('c', constPool);
        this.setValue("java.lang.Class");
    }

    @Override
    Object getValue(ClassLoader classLoader, ClassPool classPool, Method method) throws ClassNotFoundException {
        String string = this.getValue();
        if (string.equals("void")) {
            return Void.TYPE;
        }
        if (string.equals("int")) {
            return Integer.TYPE;
        }
        if (string.equals("byte")) {
            return Byte.TYPE;
        }
        if (string.equals("long")) {
            return Long.TYPE;
        }
        if (string.equals("double")) {
            return Double.TYPE;
        }
        if (string.equals("float")) {
            return Float.TYPE;
        }
        if (string.equals("char")) {
            return Character.TYPE;
        }
        if (string.equals("short")) {
            return Short.TYPE;
        }
        if (string.equals("boolean")) {
            return Boolean.TYPE;
        }
        return ClassMemberValue.loadClass(classLoader, string);
    }

    @Override
    Class getType(ClassLoader classLoader) throws ClassNotFoundException {
        return ClassMemberValue.loadClass(classLoader, "java.lang.Class");
    }

    public String getValue() {
        String string = this.cp.getUtf8Info(this.valueIndex);
        return Descriptor.toClassName(string);
    }

    public void setValue(String string) {
        String string2 = Descriptor.of(string);
        this.valueIndex = this.cp.addUtf8Info(string2);
    }

    public String toString() {
        return "<" + this.getValue() + " class>";
    }

    @Override
    public void write(AnnotationsWriter annotationsWriter) throws IOException {
        annotationsWriter.classInfoIndex(this.cp.getUtf8Info(this.valueIndex));
    }

    @Override
    public void accept(MemberValueVisitor memberValueVisitor) {
        memberValueVisitor.visitClassMemberValue(this);
    }
}

