/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode.analysis;

import com.jpattern.javassist.bytecode.BadBytecode;
import com.jpattern.javassist.bytecode.CodeAttribute;
import com.jpattern.javassist.bytecode.CodeIterator;
import com.jpattern.javassist.bytecode.ExceptionTable;
import com.jpattern.javassist.bytecode.MethodInfo;
import com.jpattern.javassist.bytecode.Opcode;
import com.jpattern.javassist.bytecode.analysis.Subroutine;
import com.jpattern.javassist.bytecode.analysis.Util;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SubroutineScanner
implements Opcode {
    private Subroutine[] subroutines;
    Map subTable = new HashMap();
    Set done = new HashSet();

    public Subroutine[] scan(MethodInfo methodInfo) throws BadBytecode {
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        CodeIterator codeIterator = codeAttribute.iterator();
        this.subroutines = new Subroutine[codeAttribute.getCodeLength()];
        this.subTable.clear();
        this.done.clear();
        this.scan(0, codeIterator, null);
        ExceptionTable exceptionTable = codeAttribute.getExceptionTable();
        for (int i = 0; i < exceptionTable.size(); ++i) {
            int n = exceptionTable.handlerPc(i);
            this.scan(n, codeIterator, this.subroutines[exceptionTable.startPc(i)]);
        }
        return this.subroutines;
    }

    private void scan(int n, CodeIterator codeIterator, Subroutine subroutine) throws BadBytecode {
        boolean bl;
        if (this.done.contains(new Integer(n))) {
            return;
        }
        this.done.add(new Integer(n));
        int n2 = codeIterator.lookAhead();
        codeIterator.move(n);
        while (bl = this.scanOp(n = codeIterator.next(), codeIterator, subroutine) && codeIterator.hasNext()) {
        }
        codeIterator.move(n2);
    }

    private boolean scanOp(int n, CodeIterator codeIterator, Subroutine subroutine) throws BadBytecode {
        this.subroutines[n] = subroutine;
        int n2 = codeIterator.byteAt(n);
        if (n2 == 170) {
            this.scanTableSwitch(n, codeIterator, subroutine);
            return false;
        }
        if (n2 == 171) {
            this.scanLookupSwitch(n, codeIterator, subroutine);
            return false;
        }
        if (Util.isReturn(n2) || n2 == 169 || n2 == 191) {
            return false;
        }
        if (Util.isJumpInstruction(n2)) {
            int n3 = Util.getJumpTarget(n, codeIterator);
            if (n2 == 168 || n2 == 201) {
                Subroutine subroutine2 = (Subroutine)this.subTable.get(new Integer(n3));
                if (subroutine2 == null) {
                    subroutine2 = new Subroutine(n3, n);
                    this.subTable.put(new Integer(n3), subroutine2);
                    this.scan(n3, codeIterator, subroutine2);
                } else {
                    subroutine2.addCaller(n);
                }
            } else {
                this.scan(n3, codeIterator, subroutine);
                if (Util.isGoto(n2)) {
                    return false;
                }
            }
        }
        return true;
    }

    private void scanLookupSwitch(int n, CodeIterator codeIterator, Subroutine subroutine) throws BadBytecode {
        int n2 = (n & 0xFFFFFFFC) + 4;
        this.scan(n + codeIterator.s32bitAt(n2), codeIterator, subroutine);
        int n3 = codeIterator.s32bitAt(n2 += 4);
        int n4 = n3 * 8 + (n2 += 4);
        n2 += 4;
        while (n2 < n4) {
            int n5 = codeIterator.s32bitAt(n2) + n;
            this.scan(n5, codeIterator, subroutine);
            n2 += 8;
        }
    }

    private void scanTableSwitch(int n, CodeIterator codeIterator, Subroutine subroutine) throws BadBytecode {
        int n2 = (n & 0xFFFFFFFC) + 4;
        this.scan(n + codeIterator.s32bitAt(n2), codeIterator, subroutine);
        int n3 = codeIterator.s32bitAt(n2 += 4);
        int n4 = codeIterator.s32bitAt(n2 += 4);
        int n5 = (n4 - n3 + 1) * 4 + (n2 += 4);
        while (n2 < n5) {
            int n6 = codeIterator.s32bitAt(n2) + n;
            this.scan(n6, codeIterator, subroutine);
            n2 += 4;
        }
    }
}

