/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode;

import com.jpattern.javassist.bytecode.ConstInfo;
import com.jpattern.javassist.bytecode.ConstPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

class IntegerInfo
extends ConstInfo {
    static final int tag = 3;
    int value;

    public IntegerInfo(int n, int n2) {
        super(n2);
        this.value = n;
    }

    public IntegerInfo(DataInputStream dataInputStream, int n) throws IOException {
        super(n);
        this.value = dataInputStream.readInt();
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof IntegerInfo && ((IntegerInfo)object).value == this.value;
    }

    @Override
    public int getTag() {
        return 3;
    }

    @Override
    public int copy(ConstPool constPool, ConstPool constPool2, Map map) {
        return constPool2.addIntegerInfo(this.value);
    }

    @Override
    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(3);
        dataOutputStream.writeInt(this.value);
    }

    @Override
    public void print(PrintWriter printWriter) {
        printWriter.print("Integer ");
        printWriter.println(this.value);
    }
}

