/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist.bytecode;

import com.jpattern.javassist.bytecode.AnnotationDefaultAttribute;
import com.jpattern.javassist.bytecode.AnnotationsAttribute;
import com.jpattern.javassist.bytecode.CodeAttribute;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.ConstantAttribute;
import com.jpattern.javassist.bytecode.DeprecatedAttribute;
import com.jpattern.javassist.bytecode.EnclosingMethodAttribute;
import com.jpattern.javassist.bytecode.ExceptionsAttribute;
import com.jpattern.javassist.bytecode.InnerClassesAttribute;
import com.jpattern.javassist.bytecode.LineNumberAttribute;
import com.jpattern.javassist.bytecode.LocalVariableAttribute;
import com.jpattern.javassist.bytecode.LocalVariableTypeAttribute;
import com.jpattern.javassist.bytecode.ParameterAnnotationsAttribute;
import com.jpattern.javassist.bytecode.SignatureAttribute;
import com.jpattern.javassist.bytecode.SourceFileAttribute;
import com.jpattern.javassist.bytecode.StackMap;
import com.jpattern.javassist.bytecode.StackMapTable;
import com.jpattern.javassist.bytecode.SyntheticAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class AttributeInfo {
    protected ConstPool constPool;
    int name;
    byte[] info;

    protected AttributeInfo(ConstPool constPool, int n, byte[] byArray) {
        this.constPool = constPool;
        this.name = n;
        this.info = byArray;
    }

    protected AttributeInfo(ConstPool constPool, String string) {
        this(constPool, string, (byte[])null);
    }

    public AttributeInfo(ConstPool constPool, String string, byte[] byArray) {
        this(constPool, constPool.addUtf8Info(string), byArray);
    }

    protected AttributeInfo(ConstPool constPool, int n, DataInputStream dataInputStream) throws IOException {
        this.constPool = constPool;
        this.name = n;
        int n2 = dataInputStream.readInt();
        this.info = new byte[n2];
        if (n2 > 0) {
            dataInputStream.readFully(this.info);
        }
    }

    static AttributeInfo read(ConstPool constPool, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        String string = constPool.getUtf8Info(n);
        if (string.charAt(0) < 'L') {
            if (string.equals("AnnotationDefault")) {
                return new AnnotationDefaultAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("Code")) {
                return new CodeAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("ConstantValue")) {
                return new ConstantAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("Deprecated")) {
                return new DeprecatedAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("EnclosingMethod")) {
                return new EnclosingMethodAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("Exceptions")) {
                return new ExceptionsAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("InnerClasses")) {
                return new InnerClassesAttribute(constPool, n, dataInputStream);
            }
        } else {
            if (string.equals("LineNumberTable")) {
                return new LineNumberAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("LocalVariableTable")) {
                return new LocalVariableAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("LocalVariableTypeTable")) {
                return new LocalVariableTypeAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("RuntimeVisibleAnnotations") || string.equals("RuntimeInvisibleAnnotations")) {
                return new AnnotationsAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("RuntimeVisibleParameterAnnotations") || string.equals("RuntimeInvisibleParameterAnnotations")) {
                return new ParameterAnnotationsAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("Signature")) {
                return new SignatureAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("SourceFile")) {
                return new SourceFileAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("Synthetic")) {
                return new SyntheticAttribute(constPool, n, dataInputStream);
            }
            if (string.equals("StackMap")) {
                return new StackMap(constPool, n, dataInputStream);
            }
            if (string.equals("StackMapTable")) {
                return new StackMapTable(constPool, n, dataInputStream);
            }
        }
        return new AttributeInfo(constPool, n, dataInputStream);
    }

    public String getName() {
        return this.constPool.getUtf8Info(this.name);
    }

    public ConstPool getConstPool() {
        return this.constPool;
    }

    public int length() {
        return this.info.length + 6;
    }

    public byte[] get() {
        return this.info;
    }

    public void set(byte[] byArray) {
        this.info = byArray;
    }

    public AttributeInfo copy(ConstPool constPool, Map map) {
        int n = this.info.length;
        byte[] byArray = this.info;
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = byArray[i];
        }
        return new AttributeInfo(constPool, this.getName(), byArray2);
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.name);
        dataOutputStream.writeInt(this.info.length);
        if (this.info.length > 0) {
            dataOutputStream.write(this.info);
        }
    }

    static int getLength(ArrayList arrayList) {
        int n = 0;
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)arrayList.get(i);
            n += attributeInfo.length();
        }
        return n;
    }

    static AttributeInfo lookup(ArrayList arrayList, String string) {
        if (arrayList == null) {
            return null;
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)listIterator.next();
            if (!attributeInfo.getName().equals(string)) continue;
            return attributeInfo;
        }
        return null;
    }

    static synchronized void remove(ArrayList arrayList, String string) {
        if (arrayList == null) {
            return;
        }
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            AttributeInfo attributeInfo = (AttributeInfo)listIterator.next();
            if (!attributeInfo.getName().equals(string)) continue;
            listIterator.remove();
        }
    }

    static void writeAll(ArrayList arrayList, DataOutputStream dataOutputStream) throws IOException {
        if (arrayList == null) {
            return;
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)arrayList.get(i);
            attributeInfo.write(dataOutputStream);
        }
    }

    static ArrayList copyAll(ArrayList arrayList, ConstPool constPool) {
        if (arrayList == null) {
            return null;
        }
        ArrayList<AttributeInfo> arrayList2 = new ArrayList<AttributeInfo>();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AttributeInfo attributeInfo = (AttributeInfo)arrayList.get(i);
            arrayList2.add(attributeInfo.copy(constPool, null));
        }
        return arrayList2;
    }

    void renameClass(String string, String string2) {
    }

    void renameClass(Map map) {
    }

    static void renameClass(List list, String string, String string2) {
        for (AttributeInfo attributeInfo : list) {
            attributeInfo.renameClass(string, string2);
        }
    }

    static void renameClass(List list, Map map) {
        for (AttributeInfo attributeInfo : list) {
            attributeInfo.renameClass(map);
        }
    }

    void getRefClasses(Map map) {
    }

    static void getRefClasses(List list, Map map) {
        for (AttributeInfo attributeInfo : list) {
            attributeInfo.getRefClasses(map);
        }
    }
}

