/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist;

import com.jpattern.javassist.CannotCompileException;
import com.jpattern.javassist.ClassMap;
import com.jpattern.javassist.CtClass;
import com.jpattern.javassist.CtConstructor;
import com.jpattern.javassist.CtMember;
import com.jpattern.javassist.CtMethod;
import com.jpattern.javassist.CtNewWrappedConstructor;
import com.jpattern.javassist.NotFoundException;
import com.jpattern.javassist.bytecode.Bytecode;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.compiler.CompileError;
import com.jpattern.javassist.compiler.Javac;

public class CtNewConstructor {
    public static final int PASS_NONE = 0;
    public static final int PASS_ARRAY = 1;
    public static final int PASS_PARAMS = 2;

    public static CtConstructor make(String string, CtClass ctClass) throws CannotCompileException {
        Javac javac = new Javac(ctClass);
        try {
            CtMember ctMember = javac.compile(string);
            if (ctMember instanceof CtConstructor) {
                return (CtConstructor)ctMember;
            }
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        throw new CannotCompileException("not a constructor");
    }

    public static CtConstructor make(CtClass[] ctClassArray, CtClass[] ctClassArray2, String string, CtClass ctClass) throws CannotCompileException {
        try {
            CtConstructor ctConstructor = new CtConstructor(ctClassArray, ctClass);
            ctConstructor.setExceptionTypes(ctClassArray2);
            ctConstructor.setBody(string);
            return ctConstructor;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
    }

    public static CtConstructor copy(CtConstructor ctConstructor, CtClass ctClass, ClassMap classMap) throws CannotCompileException {
        return new CtConstructor(ctConstructor, ctClass, classMap);
    }

    public static CtConstructor defaultConstructor(CtClass ctClass) throws CannotCompileException {
        CtConstructor ctConstructor = new CtConstructor((CtClass[])null, ctClass);
        ConstPool constPool = ctClass.getClassFile2().getConstPool();
        Bytecode bytecode = new Bytecode(constPool, 1, 1);
        bytecode.addAload(0);
        try {
            bytecode.addInvokespecial(ctClass.getSuperclass(), "<init>", "()V");
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        bytecode.add(177);
        ctConstructor.getMethodInfo2().setCodeAttribute(bytecode.toCodeAttribute());
        return ctConstructor;
    }

    public static CtConstructor skeleton(CtClass[] ctClassArray, CtClass[] ctClassArray2, CtClass ctClass) throws CannotCompileException {
        return CtNewConstructor.make(ctClassArray, ctClassArray2, 0, null, null, ctClass);
    }

    public static CtConstructor make(CtClass[] ctClassArray, CtClass[] ctClassArray2, CtClass ctClass) throws CannotCompileException {
        return CtNewConstructor.make(ctClassArray, ctClassArray2, 2, null, null, ctClass);
    }

    public static CtConstructor make(CtClass[] ctClassArray, CtClass[] ctClassArray2, int n, CtMethod ctMethod, CtMethod.ConstParameter constParameter, CtClass ctClass) throws CannotCompileException {
        return CtNewWrappedConstructor.wrapped(ctClassArray, ctClassArray2, n, ctMethod, constParameter, ctClass);
    }
}

