/*
 * Decompiled with CFR 0.152.
 */
package com.jpattern.javassist;

import com.jpattern.javassist.CannotCompileException;
import com.jpattern.javassist.ClassMap;
import com.jpattern.javassist.ClassPool;
import com.jpattern.javassist.CodeConverter;
import com.jpattern.javassist.CtBehavior;
import com.jpattern.javassist.CtClass;
import com.jpattern.javassist.CtConstructor;
import com.jpattern.javassist.CtField;
import com.jpattern.javassist.CtMember;
import com.jpattern.javassist.CtMethod;
import com.jpattern.javassist.FieldInitLink;
import com.jpattern.javassist.Modifier;
import com.jpattern.javassist.NotFoundException;
import com.jpattern.javassist.bytecode.AccessFlag;
import com.jpattern.javassist.bytecode.AnnotationsAttribute;
import com.jpattern.javassist.bytecode.AttributeInfo;
import com.jpattern.javassist.bytecode.BadBytecode;
import com.jpattern.javassist.bytecode.Bytecode;
import com.jpattern.javassist.bytecode.ClassFile;
import com.jpattern.javassist.bytecode.CodeAttribute;
import com.jpattern.javassist.bytecode.CodeIterator;
import com.jpattern.javassist.bytecode.ConstPool;
import com.jpattern.javassist.bytecode.ConstantAttribute;
import com.jpattern.javassist.bytecode.Descriptor;
import com.jpattern.javassist.bytecode.EnclosingMethodAttribute;
import com.jpattern.javassist.bytecode.FieldInfo;
import com.jpattern.javassist.bytecode.InnerClassesAttribute;
import com.jpattern.javassist.bytecode.MethodInfo;
import com.jpattern.javassist.bytecode.ParameterAnnotationsAttribute;
import com.jpattern.javassist.bytecode.annotation.Annotation;
import com.jpattern.javassist.compiler.AccessorMaker;
import com.jpattern.javassist.compiler.CompileError;
import com.jpattern.javassist.compiler.Javac;
import com.jpattern.javassist.expr.ExprEditor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;

class CtClassType
extends CtClass {
    ClassPool classPool;
    boolean wasChanged;
    private boolean wasFrozen;
    boolean wasPruned;
    boolean gcConstPool;
    ClassFile classfile;
    byte[] rawClassfile;
    private WeakReference memberCache;
    private AccessorMaker accessors;
    private FieldInitLink fieldInitializers;
    private Hashtable hiddenMethods;
    private int uniqueNumberSeed;
    private boolean doPruning = ClassPool.doPruning;
    private int getCount;
    private static final int GET_THRESHOLD = 2;

    CtClassType(String string, ClassPool classPool) {
        super(string);
        this.classPool = classPool;
        this.gcConstPool = false;
        this.wasPruned = false;
        this.wasFrozen = false;
        this.wasChanged = false;
        this.classfile = null;
        this.rawClassfile = null;
        this.memberCache = null;
        this.accessors = null;
        this.fieldInitializers = null;
        this.hiddenMethods = null;
        this.uniqueNumberSeed = 0;
        this.getCount = 0;
    }

    CtClassType(InputStream inputStream, ClassPool classPool) throws IOException {
        this((String)null, classPool);
        this.classfile = new ClassFile(new DataInputStream(inputStream));
        this.qualifiedName = this.classfile.getName();
    }

    @Override
    protected void extendToString(StringBuffer stringBuffer) {
        Object object;
        if (this.wasChanged) {
            stringBuffer.append("changed ");
        }
        if (this.wasFrozen) {
            stringBuffer.append("frozen ");
        }
        if (this.wasPruned) {
            stringBuffer.append("pruned ");
        }
        stringBuffer.append(Modifier.toString(this.getModifiers()));
        stringBuffer.append(" class ");
        stringBuffer.append(this.getName());
        try {
            String string;
            object = this.getSuperclass();
            if (object != null && !(string = ((CtClass)object).getName()).equals("java.lang.Object")) {
                stringBuffer.append(" extends " + ((CtClass)object).getName());
            }
        }
        catch (NotFoundException notFoundException) {
            stringBuffer.append(" extends ??");
        }
        try {
            object = this.getInterfaces();
            if (((CtClass[])object).length > 0) {
                stringBuffer.append(" implements ");
            }
            for (int i = 0; i < ((CtClass[])object).length; ++i) {
                stringBuffer.append(((CtClass)object[i]).getName());
                stringBuffer.append(", ");
            }
        }
        catch (NotFoundException notFoundException) {
            stringBuffer.append(" extends ??");
        }
        object = this.getMembers();
        this.exToString(stringBuffer, " fields=", ((CtMember.Cache)object).fieldHead(), ((CtMember.Cache)object).lastField());
        this.exToString(stringBuffer, " constructors=", ((CtMember.Cache)object).consHead(), ((CtMember.Cache)object).lastCons());
        this.exToString(stringBuffer, " methods=", ((CtMember.Cache)object).methodHead(), ((CtMember.Cache)object).lastMethod());
    }

    private void exToString(StringBuffer stringBuffer, String string, CtMember ctMember, CtMember ctMember2) {
        stringBuffer.append(string);
        while (ctMember != ctMember2) {
            ctMember = ctMember.next();
            stringBuffer.append(ctMember);
            stringBuffer.append(", ");
        }
    }

    @Override
    public AccessorMaker getAccessorMaker() {
        if (this.accessors == null) {
            this.accessors = new AccessorMaker(this);
        }
        return this.accessors;
    }

    @Override
    public ClassFile getClassFile2() {
        ClassFile classFile = this.classfile;
        if (classFile != null) {
            return classFile;
        }
        this.classPool.compress();
        if (this.rawClassfile != null) {
            try {
                this.classfile = new ClassFile(new DataInputStream(new ByteArrayInputStream(this.rawClassfile)));
                this.rawClassfile = null;
                this.getCount = 2;
                return this.classfile;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString(), iOException);
            }
        }
        InputStream inputStream = null;
        try {
            inputStream = this.classPool.openClassfile(this.getName());
            if (inputStream == null) {
                throw new NotFoundException(this.getName());
            }
            ClassFile classFile2 = new ClassFile(new DataInputStream(inputStream = new BufferedInputStream(inputStream)));
            if (!classFile2.getName().equals(this.qualifiedName)) {
                throw new RuntimeException("cannot find " + this.qualifiedName + ": " + classFile2.getName() + " found in " + this.qualifiedName.replace('.', '/') + ".class");
            }
            this.classfile = classFile2;
            ClassFile classFile3 = classFile2;
            return classFile3;
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException.toString(), notFoundException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString(), iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    final void incGetCounter() {
        ++this.getCount;
    }

    @Override
    void compress() {
        if (this.getCount < 2) {
            if (!this.isModified() && ClassPool.releaseUnmodifiedClassFile) {
                this.removeClassFile();
            } else if (this.isFrozen() && !this.wasPruned) {
                this.saveClassFile();
            }
        }
        this.getCount = 0;
    }

    private synchronized void saveClassFile() {
        if (this.classfile == null || this.hasMemberCache() != null) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.classfile.write(dataOutputStream);
            byteArrayOutputStream.close();
            this.rawClassfile = byteArrayOutputStream.toByteArray();
            this.classfile = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void removeClassFile() {
        if (this.classfile != null && !this.isModified() && this.hasMemberCache() == null) {
            this.classfile = null;
        }
    }

    @Override
    public ClassPool getClassPool() {
        return this.classPool;
    }

    void setClassPool(ClassPool classPool) {
        this.classPool = classPool;
    }

    @Override
    public URL getURL() throws NotFoundException {
        URL uRL = this.classPool.find(this.getName());
        if (uRL == null) {
            throw new NotFoundException(this.getName());
        }
        return uRL;
    }

    @Override
    public boolean isModified() {
        return this.wasChanged;
    }

    @Override
    public boolean isFrozen() {
        return this.wasFrozen;
    }

    @Override
    public void freeze() {
        this.wasFrozen = true;
    }

    @Override
    void checkModify() throws RuntimeException {
        if (this.isFrozen()) {
            String string = this.getName() + " class is frozen";
            if (this.wasPruned) {
                string = string + " and pruned";
            }
            throw new RuntimeException(string);
        }
        this.wasChanged = true;
    }

    @Override
    public void defrost() {
        this.checkPruned("defrost");
        this.wasFrozen = false;
    }

    @Override
    public boolean subtypeOf(CtClass ctClass) throws NotFoundException {
        int n;
        String string = ctClass.getName();
        if (this == ctClass || this.getName().equals(string)) {
            return true;
        }
        ClassFile classFile = this.getClassFile2();
        String string2 = classFile.getSuperclass();
        if (string2 != null && string2.equals(string)) {
            return true;
        }
        String[] stringArray = classFile.getInterfaces();
        int n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            if (!stringArray[n].equals(string)) continue;
            return true;
        }
        if (string2 != null && this.classPool.get(string2).subtypeOf(ctClass)) {
            return true;
        }
        for (n = 0; n < n2; ++n) {
            if (!this.classPool.get(stringArray[n]).subtypeOf(ctClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setName(String string) throws RuntimeException {
        String string2 = this.getName();
        if (string.equals(string2)) {
            return;
        }
        this.classPool.checkNotFrozen(string);
        ClassFile classFile = this.getClassFile2();
        super.setName(string);
        classFile.setName(string);
        this.nameReplaced();
        this.classPool.classNameChanged(string2, this);
    }

    @Override
    public void replaceClassName(ClassMap classMap) throws RuntimeException {
        String string = this.getName();
        String string2 = (String)classMap.get(Descriptor.toJvmName(string));
        if (string2 != null) {
            string2 = Descriptor.toJavaName(string2);
            this.classPool.checkNotFrozen(string2);
        }
        super.replaceClassName(classMap);
        ClassFile classFile = this.getClassFile2();
        classFile.renameClass(classMap);
        this.nameReplaced();
        if (string2 != null) {
            super.setName(string2);
            this.classPool.classNameChanged(string, this);
        }
    }

    @Override
    public void replaceClassName(String string, String string2) throws RuntimeException {
        String string3 = this.getName();
        if (string3.equals(string)) {
            this.setName(string2);
        } else {
            super.replaceClassName(string, string2);
            this.getClassFile2().renameClass(string, string2);
            this.nameReplaced();
        }
    }

    @Override
    public boolean isInterface() {
        return Modifier.isInterface(this.getModifiers());
    }

    @Override
    public boolean isAnnotation() {
        return Modifier.isAnnotation(this.getModifiers());
    }

    @Override
    public boolean isEnum() {
        return Modifier.isEnum(this.getModifiers());
    }

    @Override
    public int getModifiers() {
        ClassFile classFile = this.getClassFile2();
        int n = classFile.getAccessFlags();
        n = AccessFlag.clear(n, 32);
        int n2 = classFile.getInnerAccessFlags();
        if (n2 != -1 && (n2 & 8) != 0) {
            n |= 8;
        }
        return AccessFlag.toModifier(n);
    }

    @Override
    public CtClass[] getNestedClasses() throws NotFoundException {
        ClassFile classFile = this.getClassFile2();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            return new CtClass[0];
        }
        String string = classFile.getName() + "$";
        int n = innerClassesAttribute.tableLength();
        ArrayList<CtClass> arrayList = new ArrayList<CtClass>(n);
        for (int i = 0; i < n; ++i) {
            String string2 = innerClassesAttribute.innerClass(i);
            if (string2 == null || !string2.startsWith(string) || string2.lastIndexOf(36) >= string.length()) continue;
            arrayList.add(this.classPool.get(string2));
        }
        return arrayList.toArray(new CtClass[arrayList.size()]);
    }

    @Override
    public void setModifiers(int n) {
        ClassFile classFile = this.getClassFile2();
        if (Modifier.isStatic(n)) {
            int n2 = classFile.getInnerAccessFlags();
            if (n2 != -1 && (n2 & 8) != 0) {
                n &= 0xFFFFFFF7;
            } else {
                throw new RuntimeException("cannot change " + this.getName() + " into a static class");
            }
        }
        this.checkModify();
        classFile.setAccessFlags(AccessFlag.of(n));
    }

    @Override
    public boolean hasAnnotation(Class clazz) {
        ClassFile classFile = this.getClassFile2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.hasAnnotationType(clazz, this.getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    static boolean hasAnnotationType(Class clazz, ClassPool classPool, AnnotationsAttribute annotationsAttribute, AnnotationsAttribute annotationsAttribute2) {
        int n;
        Annotation[] annotationArray = annotationsAttribute == null ? null : annotationsAttribute.getAnnotations();
        Annotation[] annotationArray2 = annotationsAttribute2 == null ? null : annotationsAttribute2.getAnnotations();
        String string = clazz.getName();
        if (annotationArray != null) {
            for (n = 0; n < annotationArray.length; ++n) {
                if (!annotationArray[n].getTypeName().equals(string)) continue;
                return true;
            }
        }
        if (annotationArray2 != null) {
            for (n = 0; n < annotationArray2.length; ++n) {
                if (!annotationArray2[n].getTypeName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getAnnotation(Class clazz) throws ClassNotFoundException {
        ClassFile classFile = this.getClassFile2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.getAnnotationType(clazz, this.getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    static Object getAnnotationType(Class clazz, ClassPool classPool, AnnotationsAttribute annotationsAttribute, AnnotationsAttribute annotationsAttribute2) throws ClassNotFoundException {
        int n;
        Annotation[] annotationArray = annotationsAttribute == null ? null : annotationsAttribute.getAnnotations();
        Annotation[] annotationArray2 = annotationsAttribute2 == null ? null : annotationsAttribute2.getAnnotations();
        String string = clazz.getName();
        if (annotationArray != null) {
            for (n = 0; n < annotationArray.length; ++n) {
                if (!annotationArray[n].getTypeName().equals(string)) continue;
                return CtClassType.toAnnoType(annotationArray[n], classPool);
            }
        }
        if (annotationArray2 != null) {
            for (n = 0; n < annotationArray2.length; ++n) {
                if (!annotationArray2[n].getTypeName().equals(string)) continue;
                return CtClassType.toAnnoType(annotationArray2[n], classPool);
            }
        }
        return null;
    }

    @Override
    public Object[] getAnnotations() throws ClassNotFoundException {
        return this.getAnnotations(false);
    }

    @Override
    public Object[] getAvailableAnnotations() {
        try {
            return this.getAnnotations(true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("Unexpected exception ", classNotFoundException);
        }
    }

    private Object[] getAnnotations(boolean bl) throws ClassNotFoundException {
        ClassFile classFile = this.getClassFile2();
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)classFile.getAttribute("RuntimeInvisibleAnnotations");
        AnnotationsAttribute annotationsAttribute2 = (AnnotationsAttribute)classFile.getAttribute("RuntimeVisibleAnnotations");
        return CtClassType.toAnnotationType(bl, this.getClassPool(), annotationsAttribute, annotationsAttribute2);
    }

    static Object[] toAnnotationType(boolean bl, ClassPool classPool, AnnotationsAttribute annotationsAttribute, AnnotationsAttribute annotationsAttribute2) throws ClassNotFoundException {
        int n;
        int n2;
        Annotation[] annotationArray;
        int n3;
        Annotation[] annotationArray2;
        if (annotationsAttribute == null) {
            annotationArray2 = null;
            n3 = 0;
        } else {
            annotationArray2 = annotationsAttribute.getAnnotations();
            n3 = annotationArray2.length;
        }
        if (annotationsAttribute2 == null) {
            annotationArray = null;
            n2 = 0;
        } else {
            annotationArray = annotationsAttribute2.getAnnotations();
            n2 = annotationArray.length;
        }
        if (!bl) {
            int n4;
            Object[] objectArray = new Object[n3 + n2];
            for (n4 = 0; n4 < n3; ++n4) {
                objectArray[n4] = CtClassType.toAnnoType(annotationArray2[n4], classPool);
            }
            for (n4 = 0; n4 < n2; ++n4) {
                objectArray[n4 + n3] = CtClassType.toAnnoType(annotationArray[n4], classPool);
            }
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < n3; ++n) {
            try {
                arrayList.add(CtClassType.toAnnoType(annotationArray2[n], classPool));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        for (n = 0; n < n2; ++n) {
            try {
                arrayList.add(CtClassType.toAnnoType(annotationArray[n], classPool));
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return arrayList.toArray();
    }

    static Object[][] toAnnotationType(boolean bl, ClassPool classPool, ParameterAnnotationsAttribute parameterAnnotationsAttribute, ParameterAnnotationsAttribute parameterAnnotationsAttribute2, MethodInfo methodInfo) throws ClassNotFoundException {
        int n = 0;
        n = parameterAnnotationsAttribute != null ? parameterAnnotationsAttribute.numParameters() : (parameterAnnotationsAttribute2 != null ? parameterAnnotationsAttribute2.numParameters() : Descriptor.numOfParameters(methodInfo.getDescriptor()));
        Object[][] objectArray = new Object[n][];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            Annotation[] annotationArray;
            int n4;
            Annotation[] annotationArray2;
            if (parameterAnnotationsAttribute == null) {
                annotationArray2 = null;
                n4 = 0;
            } else {
                annotationArray2 = parameterAnnotationsAttribute.getAnnotations()[i];
                n4 = annotationArray2.length;
            }
            if (parameterAnnotationsAttribute2 == null) {
                annotationArray = null;
                n3 = 0;
            } else {
                annotationArray = parameterAnnotationsAttribute2.getAnnotations()[i];
                n3 = annotationArray.length;
            }
            if (!bl) {
                int n5;
                objectArray[i] = new Object[n4 + n3];
                for (n5 = 0; n5 < n4; ++n5) {
                    objectArray[i][n5] = CtClassType.toAnnoType(annotationArray2[n5], classPool);
                }
                for (n5 = 0; n5 < n3; ++n5) {
                    objectArray[i][n5 + n4] = CtClassType.toAnnoType(annotationArray[n5], classPool);
                }
                continue;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (n2 = 0; n2 < n4; ++n2) {
                try {
                    arrayList.add(CtClassType.toAnnoType(annotationArray2[n2], classPool));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    arrayList.add(CtClassType.toAnnoType(annotationArray[n2], classPool));
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            objectArray[i] = arrayList.toArray();
        }
        return objectArray;
    }

    private static Object toAnnoType(Annotation annotation, ClassPool classPool) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = classPool.getClassLoader();
            return annotation.toAnnotationType(classLoader, classPool);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ClassLoader classLoader = classPool.getClass().getClassLoader();
            return annotation.toAnnotationType(classLoader, classPool);
        }
    }

    @Override
    public boolean subclassOf(CtClass ctClass) {
        if (ctClass == null) {
            return false;
        }
        String string = ctClass.getName();
        try {
            for (CtClass ctClass2 = this; ctClass2 != null; ctClass2 = ((CtClass)ctClass2).getSuperclass()) {
                if (!ctClass2.getName().equals(string)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public CtClass getSuperclass() throws NotFoundException {
        String string = this.getClassFile2().getSuperclass();
        if (string == null) {
            return null;
        }
        return this.classPool.get(string);
    }

    @Override
    public void setSuperclass(CtClass ctClass) throws CannotCompileException {
        this.checkModify();
        if (this.isInterface()) {
            this.addInterface(ctClass);
        } else {
            this.getClassFile2().setSuperclass(ctClass.getName());
        }
    }

    @Override
    public CtClass[] getInterfaces() throws NotFoundException {
        String[] stringArray = this.getClassFile2().getInterfaces();
        int n = stringArray.length;
        CtClass[] ctClassArray = new CtClass[n];
        for (int i = 0; i < n; ++i) {
            ctClassArray[i] = this.classPool.get(stringArray[i]);
        }
        return ctClassArray;
    }

    @Override
    public void setInterfaces(CtClass[] ctClassArray) {
        String[] stringArray;
        this.checkModify();
        if (ctClassArray == null) {
            stringArray = new String[]{};
        } else {
            int n = ctClassArray.length;
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ctClassArray[i].getName();
            }
        }
        this.getClassFile2().setInterfaces(stringArray);
    }

    @Override
    public void addInterface(CtClass ctClass) {
        this.checkModify();
        if (ctClass != null) {
            this.getClassFile2().addInterface(ctClass.getName());
        }
    }

    @Override
    public CtClass getDeclaringClass() throws NotFoundException {
        ClassFile classFile = this.getClassFile2();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            return null;
        }
        String string = this.getName();
        int n = innerClassesAttribute.tableLength();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(innerClassesAttribute.innerClass(i))) continue;
            String string2 = innerClassesAttribute.outerClass(i);
            if (string2 != null) {
                return this.classPool.get(string2);
            }
            EnclosingMethodAttribute enclosingMethodAttribute = (EnclosingMethodAttribute)classFile.getAttribute("EnclosingMethod");
            if (enclosingMethodAttribute == null) continue;
            return this.classPool.get(enclosingMethodAttribute.className());
        }
        return null;
    }

    @Override
    public CtMethod getEnclosingMethod() throws NotFoundException {
        ClassFile classFile = this.getClassFile2();
        EnclosingMethodAttribute enclosingMethodAttribute = (EnclosingMethodAttribute)classFile.getAttribute("EnclosingMethod");
        if (enclosingMethodAttribute != null) {
            CtClass ctClass = this.classPool.get(enclosingMethodAttribute.className());
            return ctClass.getMethod(enclosingMethodAttribute.methodName(), enclosingMethodAttribute.methodDescriptor());
        }
        return null;
    }

    @Override
    public CtClass makeNestedClass(String string, boolean bl) {
        if (!bl) {
            throw new RuntimeException("sorry, only nested static class is supported");
        }
        this.checkModify();
        CtClass ctClass = this.classPool.makeNestedClass(this.getName() + "$" + string);
        ClassFile classFile = this.getClassFile2();
        ClassFile classFile2 = ctClass.getClassFile2();
        InnerClassesAttribute innerClassesAttribute = (InnerClassesAttribute)classFile.getAttribute("InnerClasses");
        if (innerClassesAttribute == null) {
            innerClassesAttribute = new InnerClassesAttribute(classFile.getConstPool());
            classFile.addAttribute(innerClassesAttribute);
        }
        innerClassesAttribute.append(ctClass.getName(), this.getName(), string, classFile2.getAccessFlags() & 0xFFFFFFDF | 8);
        classFile2.addAttribute(innerClassesAttribute.copy(classFile2.getConstPool(), null));
        return ctClass;
    }

    private void nameReplaced() {
        CtMember.Cache cache = this.hasMemberCache();
        if (cache != null) {
            CtMember ctMember = cache.lastMethod();
            for (CtMember ctMember2 = cache.methodHead(); ctMember2 != ctMember; ctMember2 = ctMember2.next()) {
                ctMember2.nameReplaced();
            }
        }
    }

    protected CtMember.Cache hasMemberCache() {
        if (this.memberCache != null) {
            return (CtMember.Cache)this.memberCache.get();
        }
        return null;
    }

    protected synchronized CtMember.Cache getMembers() {
        CtMember.Cache cache = null;
        if (this.memberCache == null || (cache = (CtMember.Cache)this.memberCache.get()) == null) {
            cache = new CtMember.Cache(this);
            this.makeFieldCache(cache);
            this.makeBehaviorCache(cache);
            this.memberCache = new WeakReference<CtMember.Cache>(cache);
        }
        return cache;
    }

    private void makeFieldCache(CtMember.Cache cache) {
        List list = this.getClassFile2().getFields();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            FieldInfo fieldInfo = (FieldInfo)list.get(i);
            CtField ctField = new CtField(fieldInfo, (CtClass)this);
            cache.addField(ctField);
        }
    }

    private void makeBehaviorCache(CtMember.Cache cache) {
        List list = this.getClassFile2().getMethods();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CtBehavior ctBehavior;
            MethodInfo methodInfo = (MethodInfo)list.get(i);
            if (methodInfo.isMethod()) {
                ctBehavior = new CtMethod(methodInfo, this);
                cache.addMethod(ctBehavior);
                continue;
            }
            ctBehavior = new CtConstructor(methodInfo, (CtClass)this);
            cache.addConstructor(ctBehavior);
        }
    }

    @Override
    public CtField[] getFields() {
        ArrayList arrayList = new ArrayList();
        CtClassType.getFields(arrayList, this);
        return arrayList.toArray(new CtField[arrayList.size()]);
    }

    private static void getFields(ArrayList arrayList, CtClass ctClass) {
        Object object;
        if (ctClass == null) {
            return;
        }
        try {
            CtClassType.getFields(arrayList, ctClass.getSuperclass());
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            object = ctClass.getInterfaces();
            int n = ((CtClass[])object).length;
            for (int i = 0; i < n; ++i) {
                CtClassType.getFields(arrayList, (CtClass)object[i]);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        object = ((CtClassType)ctClass).getMembers();
        CtMember ctMember = ((CtMember.Cache)object).fieldHead();
        CtMember ctMember2 = ((CtMember.Cache)object).lastField();
        while (ctMember != ctMember2) {
            if (Modifier.isPrivate((ctMember = ctMember.next()).getModifiers())) continue;
            arrayList.add(ctMember);
        }
    }

    @Override
    public CtField getField(String string, String string2) throws NotFoundException {
        CtField ctField = this.getField2(string, string2);
        return this.checkGetField(ctField, string, string2);
    }

    private CtField checkGetField(CtField ctField, String string, String string2) throws NotFoundException {
        if (ctField == null) {
            String string3 = "field: " + string;
            if (string2 != null) {
                string3 = string3 + " type " + string2;
            }
            throw new NotFoundException(string3 + " in " + this.getName());
        }
        return ctField;
    }

    @Override
    CtField getField2(String string, String string2) {
        CtField ctField = this.getDeclaredField2(string, string2);
        if (ctField != null) {
            return ctField;
        }
        try {
            CtClass[] ctClassArray = this.getInterfaces();
            int n = ctClassArray.length;
            for (int i = 0; i < n; ++i) {
                CtField ctField2 = ctClassArray[i].getField2(string, string2);
                if (ctField2 == null) continue;
                return ctField2;
            }
            CtClass ctClass = this.getSuperclass();
            if (ctClass != null) {
                return ctClass.getField2(string, string2);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public CtField[] getDeclaredFields() {
        CtMember ctMember;
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember2 = cache.lastField();
        int n = CtMember.Cache.count(ctMember, ctMember2);
        CtField[] ctFieldArray = new CtField[n];
        int n2 = 0;
        for (ctMember = cache.fieldHead(); ctMember != ctMember2; ctMember = ctMember.next()) {
            ctFieldArray[n2++] = (CtField)ctMember;
        }
        return ctFieldArray;
    }

    @Override
    public CtField getDeclaredField(String string) throws NotFoundException {
        return this.getDeclaredField(string, null);
    }

    @Override
    public CtField getDeclaredField(String string, String string2) throws NotFoundException {
        CtField ctField = this.getDeclaredField2(string, string2);
        return this.checkGetField(ctField, string, string2);
    }

    private CtField getDeclaredField2(String string, String string2) {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.fieldHead();
        CtMember ctMember2 = cache.lastField();
        while (ctMember != ctMember2) {
            if (!(ctMember = ctMember.next()).getName().equals(string) || string2 != null && !string2.equals(ctMember.getSignature())) continue;
            return (CtField)ctMember;
        }
        return null;
    }

    @Override
    public CtBehavior[] getDeclaredBehaviors() {
        CtMember ctMember;
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember2 = cache.lastCons();
        int n = CtMember.Cache.count(ctMember, ctMember2);
        CtMember ctMember3 = cache.methodHead();
        CtMember ctMember4 = cache.lastMethod();
        int n2 = CtMember.Cache.count(ctMember3, ctMember4);
        CtBehavior[] ctBehaviorArray = new CtBehavior[n + n2];
        int n3 = 0;
        for (ctMember = cache.consHead(); ctMember != ctMember2; ctMember = ctMember.next()) {
            ctBehaviorArray[n3++] = (CtBehavior)ctMember;
        }
        while (ctMember3 != ctMember4) {
            ctMember3 = ctMember3.next();
            ctBehaviorArray[n3++] = (CtBehavior)ctMember3;
        }
        return ctBehaviorArray;
    }

    @Override
    public CtConstructor[] getConstructors() {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.consHead();
        CtMember ctMember2 = cache.lastCons();
        int n = 0;
        CtMember ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            if (!CtClassType.isPubCons((CtConstructor)(ctMember3 = ctMember3.next()))) continue;
            ++n;
        }
        CtConstructor[] ctConstructorArray = new CtConstructor[n];
        int n2 = 0;
        ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember3 = ctMember3.next());
            if (!CtClassType.isPubCons(ctConstructor)) continue;
            ctConstructorArray[n2++] = ctConstructor;
        }
        return ctConstructorArray;
    }

    private static boolean isPubCons(CtConstructor ctConstructor) {
        return !Modifier.isPrivate(ctConstructor.getModifiers()) && ctConstructor.isConstructor();
    }

    @Override
    public CtConstructor getConstructor(String string) throws NotFoundException {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.consHead();
        CtMember ctMember2 = cache.lastCons();
        while (ctMember != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember = ctMember.next());
            if (!ctConstructor.getMethodInfo2().getDescriptor().equals(string) || !ctConstructor.isConstructor()) continue;
            return ctConstructor;
        }
        return super.getConstructor(string);
    }

    @Override
    public CtConstructor[] getDeclaredConstructors() {
        Object object;
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.consHead();
        CtMember ctMember2 = cache.lastCons();
        int n = 0;
        CtMember ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            object = (CtConstructor)(ctMember3 = ctMember3.next());
            if (!((CtConstructor)object).isConstructor()) continue;
            ++n;
        }
        object = new CtConstructor[n];
        int n2 = 0;
        ctMember3 = ctMember;
        while (ctMember3 != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember3 = ctMember3.next());
            if (!ctConstructor.isConstructor()) continue;
            object[n2++] = ctConstructor;
        }
        return object;
    }

    @Override
    public CtConstructor getClassInitializer() {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.consHead();
        CtMember ctMember2 = cache.lastCons();
        while (ctMember != ctMember2) {
            CtConstructor ctConstructor = (CtConstructor)(ctMember = ctMember.next());
            if (!ctConstructor.isClassInitializer()) continue;
            return ctConstructor;
        }
        return null;
    }

    @Override
    public CtMethod[] getMethods() {
        HashMap hashMap = new HashMap();
        CtClassType.getMethods0(hashMap, this);
        return hashMap.values().toArray(new CtMethod[hashMap.size()]);
    }

    private static void getMethods0(HashMap hashMap, CtClass ctClass) {
        Object object;
        try {
            object = ctClass.getInterfaces();
            int n = ((CtClass[])object).length;
            for (int i = 0; i < n; ++i) {
                CtClassType.getMethods0(hashMap, (CtClass)object[i]);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            object = ctClass.getSuperclass();
            if (object != null) {
                CtClassType.getMethods0(hashMap, (CtClass)object);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        if (ctClass instanceof CtClassType) {
            object = ((CtClassType)ctClass).getMembers();
            CtMember ctMember = ((CtMember.Cache)object).methodHead();
            CtMember ctMember2 = ((CtMember.Cache)object).lastMethod();
            while (ctMember != ctMember2) {
                if (Modifier.isPrivate((ctMember = ctMember.next()).getModifiers())) continue;
                hashMap.put(((CtMethod)ctMember).getStringRep(), ctMember);
            }
        }
    }

    @Override
    public CtMethod getMethod(String string, String string2) throws NotFoundException {
        CtMethod ctMethod = CtClassType.getMethod0(this, string, string2);
        if (ctMethod != null) {
            return ctMethod;
        }
        throw new NotFoundException(string + "(..) is not found in " + this.getName());
    }

    private static CtMethod getMethod0(CtClass ctClass, String string, String string2) {
        CtMember ctMember;
        CtClass[] ctClassArray;
        if (ctClass instanceof CtClassType) {
            ctClassArray = ((CtClassType)ctClass).getMembers();
            ctMember = ctClassArray.methodHead();
            CtMember ctMember2 = ctClassArray.lastMethod();
            while (ctMember != ctMember2) {
                if (!(ctMember = ctMember.next()).getName().equals(string) || !((CtMethod)ctMember).getMethodInfo2().getDescriptor().equals(string2)) continue;
                return (CtMethod)ctMember;
            }
        }
        try {
            ctClassArray = ctClass.getSuperclass();
            if (ctClassArray != null && (ctMember = CtClassType.getMethod0((CtClass)ctClassArray, string, string2)) != null) {
                return ctMember;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctClassArray = ctClass.getInterfaces();
            int n = ctClassArray.length;
            for (int i = 0; i < n; ++i) {
                CtMethod ctMethod = CtClassType.getMethod0(ctClassArray[i], string, string2);
                if (ctMethod == null) continue;
                return ctMethod;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public CtMethod[] getDeclaredMethods() {
        CtMember ctMember;
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember2 = cache.lastMethod();
        int n = CtMember.Cache.count(ctMember, ctMember2);
        CtMethod[] ctMethodArray = new CtMethod[n];
        int n2 = 0;
        for (ctMember = cache.methodHead(); ctMember != ctMember2; ctMember = ctMember.next()) {
            ctMethodArray[n2++] = (CtMethod)ctMember;
        }
        return ctMethodArray;
    }

    @Override
    public CtMethod getDeclaredMethod(String string) throws NotFoundException {
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.methodHead();
        CtMember ctMember2 = cache.lastMethod();
        while (ctMember != ctMember2) {
            if (!(ctMember = ctMember.next()).getName().equals(string)) continue;
            return (CtMethod)ctMember;
        }
        throw new NotFoundException(string + "(..) is not found in " + this.getName());
    }

    @Override
    public CtMethod getDeclaredMethod(String string, CtClass[] ctClassArray) throws NotFoundException {
        String string2 = Descriptor.ofParameters(ctClassArray);
        CtMember.Cache cache = this.getMembers();
        CtMember ctMember = cache.methodHead();
        CtMember ctMember2 = cache.lastMethod();
        while (ctMember != ctMember2) {
            if (!(ctMember = ctMember.next()).getName().equals(string) || !((CtMethod)ctMember).getMethodInfo2().getDescriptor().startsWith(string2)) continue;
            return (CtMethod)ctMember;
        }
        throw new NotFoundException(string + "(..) is not found in " + this.getName());
    }

    @Override
    public void addField(CtField ctField, String string) throws CannotCompileException {
        this.addField(ctField, CtField.Initializer.byExpr(string));
    }

    @Override
    public void addField(CtField ctField, CtField.Initializer initializer) throws CannotCompileException {
        Object object;
        this.checkModify();
        if (ctField.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        if (initializer == null) {
            initializer = ctField.getInit();
        }
        if (initializer != null) {
            initializer.check(ctField.getSignature());
            int n = ctField.getModifiers();
            if (Modifier.isStatic(n) && Modifier.isFinal(n)) {
                try {
                    object = this.getClassFile2().getConstPool();
                    int n2 = initializer.getConstantValue((ConstPool)object, ctField.getType());
                    if (n2 != 0) {
                        ctField.getFieldInfo2().addAttribute(new ConstantAttribute((ConstPool)object, n2));
                        initializer = null;
                    }
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        this.getMembers().addField(ctField);
        this.getClassFile2().addField(ctField.getFieldInfo2());
        if (initializer != null) {
            FieldInitLink fieldInitLink = new FieldInitLink(ctField, initializer);
            object = this.fieldInitializers;
            if (object == null) {
                this.fieldInitializers = fieldInitLink;
            } else {
                while (((FieldInitLink)object).next != null) {
                    object = ((FieldInitLink)object).next;
                }
                ((FieldInitLink)object).next = fieldInitLink;
            }
        }
    }

    @Override
    public void removeField(CtField ctField) throws NotFoundException {
        this.checkModify();
        FieldInfo fieldInfo = ctField.getFieldInfo2();
        ClassFile classFile = this.getClassFile2();
        if (!classFile.getFields().remove(fieldInfo)) {
            throw new NotFoundException(ctField.toString());
        }
        this.getMembers().remove(ctField);
        this.gcConstPool = true;
    }

    @Override
    public CtConstructor makeClassInitializer() throws CannotCompileException {
        CtConstructor ctConstructor = this.getClassInitializer();
        if (ctConstructor != null) {
            return ctConstructor;
        }
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        Bytecode bytecode = new Bytecode(classFile.getConstPool(), 0, 0);
        this.modifyClassConstructor(classFile, bytecode, 0, 0);
        return this.getClassInitializer();
    }

    @Override
    public void addConstructor(CtConstructor ctConstructor) throws CannotCompileException {
        this.checkModify();
        if (ctConstructor.getDeclaringClass() != this) {
            throw new CannotCompileException("cannot add");
        }
        this.getMembers().addConstructor(ctConstructor);
        this.getClassFile2().addMethod(ctConstructor.getMethodInfo2());
    }

    @Override
    public void removeConstructor(CtConstructor ctConstructor) throws NotFoundException {
        this.checkModify();
        MethodInfo methodInfo = ctConstructor.getMethodInfo2();
        ClassFile classFile = this.getClassFile2();
        if (!classFile.getMethods().remove(methodInfo)) {
            throw new NotFoundException(ctConstructor.toString());
        }
        this.getMembers().remove(ctConstructor);
        this.gcConstPool = true;
    }

    @Override
    public void addMethod(CtMethod ctMethod) throws CannotCompileException {
        this.checkModify();
        if (ctMethod.getDeclaringClass() != this) {
            throw new CannotCompileException("bad declaring class");
        }
        int n = ctMethod.getModifiers();
        if ((this.getModifiers() & 0x200) != 0) {
            ctMethod.setModifiers(n | 1);
            if ((n & 0x400) == 0) {
                throw new CannotCompileException("an interface method must be abstract: " + ctMethod.toString());
            }
        }
        this.getMembers().addMethod(ctMethod);
        this.getClassFile2().addMethod(ctMethod.getMethodInfo2());
        if ((n & 0x400) != 0) {
            this.setModifiers(this.getModifiers() | 0x400);
        }
    }

    @Override
    public void removeMethod(CtMethod ctMethod) throws NotFoundException {
        this.checkModify();
        MethodInfo methodInfo = ctMethod.getMethodInfo2();
        ClassFile classFile = this.getClassFile2();
        if (!classFile.getMethods().remove(methodInfo)) {
            throw new NotFoundException(ctMethod.toString());
        }
        this.getMembers().remove(ctMethod);
        this.gcConstPool = true;
    }

    @Override
    public byte[] getAttribute(String string) {
        AttributeInfo attributeInfo = this.getClassFile2().getAttribute(string);
        if (attributeInfo == null) {
            return null;
        }
        return attributeInfo.get();
    }

    @Override
    public void setAttribute(String string, byte[] byArray) {
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        classFile.addAttribute(new AttributeInfo(classFile.getConstPool(), string, byArray));
    }

    @Override
    public void instrument(CodeConverter codeConverter) throws CannotCompileException {
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        ConstPool constPool = classFile.getConstPool();
        List list = classFile.getMethods();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo methodInfo = (MethodInfo)list.get(i);
            codeConverter.doit(this, methodInfo, constPool);
        }
    }

    @Override
    public void instrument(ExprEditor exprEditor) throws CannotCompileException {
        this.checkModify();
        ClassFile classFile = this.getClassFile2();
        List list = classFile.getMethods();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            MethodInfo methodInfo = (MethodInfo)list.get(i);
            exprEditor.doit(this, methodInfo);
        }
    }

    @Override
    public void prune() {
        if (this.wasPruned) {
            return;
        }
        this.wasFrozen = true;
        this.wasPruned = true;
        this.getClassFile2().prune();
    }

    @Override
    public void rebuildClassFile() {
        this.gcConstPool = true;
    }

    @Override
    public void toBytecode(DataOutputStream dataOutputStream) throws CannotCompileException, IOException {
        try {
            if (this.isModified()) {
                this.checkPruned("toBytecode");
                ClassFile classFile = this.getClassFile2();
                if (this.gcConstPool) {
                    classFile.compact();
                    this.gcConstPool = false;
                }
                this.modifyClassConstructor(classFile);
                this.modifyConstructors(classFile);
                if (debugDump != null) {
                    this.dumpClassFile(classFile);
                }
                classFile.write(dataOutputStream);
                dataOutputStream.flush();
                this.fieldInitializers = null;
                if (this.doPruning) {
                    classFile.prune();
                    this.wasPruned = true;
                }
            } else {
                this.classPool.writeClassfile(this.getName(), dataOutputStream);
            }
            this.getCount = 0;
            this.wasFrozen = true;
        }
        catch (NotFoundException notFoundException) {
            throw new CannotCompileException(notFoundException);
        }
        catch (IOException iOException) {
            throw new CannotCompileException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpClassFile(ClassFile classFile) throws IOException {
        DataOutputStream dataOutputStream = this.makeFileOutput(debugDump);
        try {
            classFile.write(dataOutputStream);
        }
        finally {
            dataOutputStream.close();
        }
    }

    private void checkPruned(String string) {
        if (this.wasPruned) {
            throw new RuntimeException(string + "(): " + this.getName() + " was pruned.");
        }
    }

    @Override
    public boolean stopPruning(boolean bl) {
        boolean bl2 = !this.doPruning;
        this.doPruning = !bl;
        return bl2;
    }

    private void modifyClassConstructor(ClassFile classFile) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        Bytecode bytecode = new Bytecode(classFile.getConstPool(), 0, 0);
        Javac javac = new Javac(bytecode, this);
        int n = 0;
        boolean bl = false;
        FieldInitLink fieldInitLink = this.fieldInitializers;
        while (fieldInitLink != null) {
            CtField ctField = fieldInitLink.field;
            if (Modifier.isStatic(ctField.getModifiers())) {
                bl = true;
                int n2 = fieldInitLink.init.compileIfStatic(ctField.getType(), ctField.getName(), bytecode, javac);
                if (n < n2) {
                    n = n2;
                }
            }
            fieldInitLink = fieldInitLink.next;
        }
        if (bl) {
            this.modifyClassConstructor(classFile, bytecode, n, 0);
        }
    }

    private void modifyClassConstructor(ClassFile classFile, Bytecode bytecode, int n, int n2) throws CannotCompileException {
        Object object;
        MethodInfo methodInfo = classFile.getStaticInitializer();
        if (methodInfo == null) {
            bytecode.add(177);
            bytecode.setMaxStack(n);
            bytecode.setMaxLocals(n2);
            methodInfo = new MethodInfo(classFile.getConstPool(), "<clinit>", "()V");
            methodInfo.setAccessFlags(8);
            methodInfo.setCodeAttribute(bytecode.toCodeAttribute());
            classFile.addMethod(methodInfo);
            object = this.hasMemberCache();
            if (object != null) {
                ((CtMember.Cache)object).addConstructor(new CtConstructor(methodInfo, (CtClass)this));
            }
        } else {
            object = methodInfo.getCodeAttribute();
            if (object == null) {
                throw new CannotCompileException("empty <clinit>");
            }
            try {
                int n3;
                CodeIterator codeIterator = ((CodeAttribute)object).iterator();
                int n4 = codeIterator.insertEx(bytecode.get());
                codeIterator.insert(bytecode.getExceptionTable(), n4);
                int n5 = ((CodeAttribute)object).getMaxStack();
                if (n5 < n) {
                    ((CodeAttribute)object).setMaxStack(n);
                }
                if ((n3 = ((CodeAttribute)object).getMaxLocals()) < n2) {
                    ((CodeAttribute)object).setMaxLocals(n2);
                }
            }
            catch (BadBytecode badBytecode) {
                throw new CannotCompileException(badBytecode);
            }
        }
        try {
            methodInfo.rebuildStackMapIf6(this.classPool, classFile);
        }
        catch (BadBytecode badBytecode) {
            throw new CannotCompileException(badBytecode);
        }
    }

    private void modifyConstructors(ClassFile classFile) throws CannotCompileException, NotFoundException {
        if (this.fieldInitializers == null) {
            return;
        }
        ConstPool constPool = classFile.getConstPool();
        List list = classFile.getMethods();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            CodeAttribute codeAttribute;
            MethodInfo methodInfo = (MethodInfo)list.get(i);
            if (!methodInfo.isConstructor() || (codeAttribute = methodInfo.getCodeAttribute()) == null) continue;
            try {
                Bytecode bytecode = new Bytecode(constPool, 0, codeAttribute.getMaxLocals());
                CtClass[] ctClassArray = Descriptor.getParameterTypes(methodInfo.getDescriptor(), this.classPool);
                int n2 = this.makeFieldInitializer(bytecode, ctClassArray);
                CtClassType.insertAuxInitializer(codeAttribute, bytecode, n2);
                methodInfo.rebuildStackMapIf6(this.classPool, classFile);
                continue;
            }
            catch (BadBytecode badBytecode) {
                throw new CannotCompileException(badBytecode);
            }
        }
    }

    private static void insertAuxInitializer(CodeAttribute codeAttribute, Bytecode bytecode, int n) throws BadBytecode {
        CodeIterator codeIterator = codeAttribute.iterator();
        int n2 = codeIterator.skipSuperConstructor();
        if (n2 < 0 && (n2 = codeIterator.skipThisConstructor()) >= 0) {
            return;
        }
        int n3 = codeIterator.insertEx(bytecode.get());
        codeIterator.insert(bytecode.getExceptionTable(), n3);
        int n4 = codeAttribute.getMaxStack();
        if (n4 < n) {
            codeAttribute.setMaxStack(n);
        }
    }

    private int makeFieldInitializer(Bytecode bytecode, CtClass[] ctClassArray) throws CannotCompileException, NotFoundException {
        int n = 0;
        Javac javac = new Javac(bytecode, this);
        try {
            javac.recordParams(ctClassArray, false);
        }
        catch (CompileError compileError) {
            throw new CannotCompileException(compileError);
        }
        FieldInitLink fieldInitLink = this.fieldInitializers;
        while (fieldInitLink != null) {
            int n2;
            CtField ctField = fieldInitLink.field;
            if (!Modifier.isStatic(ctField.getModifiers()) && n < (n2 = fieldInitLink.init.compile(ctField.getType(), ctField.getName(), bytecode, ctClassArray, javac))) {
                n = n2;
            }
            fieldInitLink = fieldInitLink.next;
        }
        return n;
    }

    Hashtable getHiddenMethods() {
        if (this.hiddenMethods == null) {
            this.hiddenMethods = new Hashtable();
        }
        return this.hiddenMethods;
    }

    int getUniqueNumber() {
        return this.uniqueNumberSeed++;
    }

    @Override
    public String makeUniqueName(String string) {
        String string2;
        HashMap hashMap = new HashMap();
        this.makeMemberList(hashMap);
        Set set = hashMap.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        if (CtClassType.notFindInArray(string, stringArray)) {
            return string;
        }
        int n = 100;
        do {
            if (n <= 999) continue;
            throw new RuntimeException("too many unique name");
        } while (!CtClassType.notFindInArray(string2 = string + n++, stringArray));
        return string2;
    }

    private static boolean notFindInArray(String string, String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].startsWith(string)) continue;
            return false;
        }
        return true;
    }

    private void makeMemberList(HashMap hashMap) {
        int n;
        Object object;
        int n2 = this.getModifiers();
        if (Modifier.isAbstract(n2) || Modifier.isInterface(n2)) {
            try {
                for (CtClass object22 : this.getInterfaces()) {
                    if (object22 == null || !(object22 instanceof CtClassType)) continue;
                    ((CtClassType)object22).makeMemberList(hashMap);
                }
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
        }
        try {
            object = this.getSuperclass();
            if (object != null && object instanceof CtClassType) {
                ((CtClassType)object).makeMemberList(hashMap);
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        object = this.getClassFile2().getMethods();
        int n3 = object.size();
        for (n = 0; n < n3; ++n) {
            MethodInfo methodInfo = (MethodInfo)object.get(n);
            hashMap.put(methodInfo.getName(), this);
        }
        object = this.getClassFile2().getFields();
        n3 = object.size();
        for (n = 0; n < n3; ++n) {
            FieldInfo fieldInfo = (FieldInfo)object.get(n);
            hashMap.put(fieldInfo.getName(), this);
        }
    }
}

