/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.redis.cluster;

import com.jeesuite.cache.redis.JedisProvider;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.BinaryJedisCluster;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class JedisClusterProvider
implements JedisProvider<JedisCluster, BinaryJedisCluster> {
    public static final String MODE = "cluster";
    private Integer maxRedirections = 3;
    private JedisCluster jedisCluster;
    private BinaryJedisCluster binaryJedisCluster;
    private String groupName;

    public JedisClusterProvider(String groupName, JedisPoolConfig jedisPoolConfig, String[] servers, int timeout) {
        this.groupName = groupName;
        Set<HostAndPort> nodes = this.parseHostAndPort(servers);
        this.jedisCluster = new JedisCluster(nodes, timeout, this.maxRedirections.intValue(), (GenericObjectPoolConfig)jedisPoolConfig);
        this.binaryJedisCluster = new BinaryJedisCluster(nodes, timeout, this.maxRedirections.intValue(), (GenericObjectPoolConfig)jedisPoolConfig);
    }

    private Set<HostAndPort> parseHostAndPort(String[] servers) {
        try {
            HashSet<HostAndPort> haps = new HashSet<HostAndPort>();
            for (String part : servers) {
                String[] ipAndPort = part.split(":");
                HostAndPort hap = new HostAndPort(ipAndPort[0], Integer.parseInt(ipAndPort[1]));
                haps.add(hap);
            }
            return haps;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public JedisCluster get() {
        return this.jedisCluster;
    }

    @Override
    public BinaryJedisCluster getBinary() {
        return this.binaryJedisCluster;
    }

    @Override
    public void release() {
    }

    public void destroy() throws Exception {
        this.jedisCluster.close();
    }

    @Override
    public String mode() {
        return MODE;
    }

    @Override
    public String groupName() {
        return this.groupName;
    }
}

