/*
 * Decompiled with CFR 0.152.
 */
package com.jeesuite.cache.local;

import com.jeesuite.common.util.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class MapCacheProvider {
    static Map<String, Object> cache = new ConcurrentHashMap<String, Object>();
    static Map<String, Date> cacheExpire = new HashMap<String, Date>();
    private Lock lock = new ReentrantLock();
    private AtomicBoolean runing = new AtomicBoolean();

    public MapCacheProvider() {
        this(5L);
    }

    public MapCacheProvider(final long period) {
        this.runing.set(true);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (MapCacheProvider.this.runing.get()) {
                    Date now = Calendar.getInstance().getTime();
                    MapCacheProvider.this.lock.lock();
                    try {
                        Iterator<Map.Entry<String, Date>> it = cacheExpire.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<String, Date> entry = it.next();
                            if (entry.getValue().compareTo(now) > 0) continue;
                            cache.remove(entry.getKey());
                            it.remove();
                        }
                        try {
                            Thread.sleep(TimeUnit.SECONDS.toMillis(period));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    finally {
                        MapCacheProvider.this.lock.unlock();
                    }
                }
            }
        }).start();
    }

    public boolean set(String key, Object value, int timeout) {
        Date expireAt = timeout > -1 ? DateUtils.add((Date)new Date(), (int)13, (int)timeout) : null;
        return this.set(key, value, expireAt);
    }

    public boolean set(String key, Object value, Date expireAt) {
        cache.put(key, value);
        if (expireAt != null) {
            cacheExpire.put(key, expireAt);
        }
        return true;
    }

    public <T> T get(String key) {
        return (T)cache.get(key);
    }

    public boolean remove(String key) {
        cache.remove(key);
        cacheExpire.remove(key);
        return true;
    }

    public boolean exists(String key) {
        return cache.containsKey(key);
    }

    public void close() {
        this.runing.set(false);
    }
}

